/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.backends.tex;

import java.io.File;
import org.luwrain.core.NullCheck;
import org.luwrain.script.core.ScriptCore;
import org.luwrain.studio.IDE;
import org.luwrain.studio.backends.tex.CompilationCommandFactory;
import org.luwrain.studio.backends.tex.TexProject;

final class TexCompilation {
    private final IDE ide;
    private final TexProject proj;

    TexCompilation(IDE ide, TexProject proj) {
        NullCheck.notNull((Object)ide, (String)"ide");
        NullCheck.notNull((Object)proj, (String)"proj");
        this.ide = ide;
        this.proj = proj;
    }

    void build() {
        this.runCompilationScript();
    }

    private void runCompilationScript() {
        ScriptCore scriptCore = new ScriptCore(this.ide.getLuwrainObj(), (bindings, syncObj) -> {
            CompilationCommandFactory factory = new CompilationCommandFactory();
            bindings.putMember("latex", (Object)factory.newCompilationCommand(this, "latex"));
        });
    }

    File getProjectDir() {
        return new File("/tmp");
    }
}

