/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio;

import java.io.IOException;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.studio.Editing;
import org.luwrain.studio.IDE;
import org.luwrain.util.Sha1;

public interface Part {
    public String getTitle();

    public Action[] getActions();

    public Part[] getChildParts();

    public Editing startEditing() throws IOException;

    public static Action action(final String title, final ActionProc proc) {
        NullCheck.notEmpty((Object)title, (String)"title");
        NullCheck.notNull((Object)proc, (String)"proc");
        final String id = Sha1.getSha1((String)title, (String)"UTF-8");
        return new Action(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getTitle() {
                return title;
            }

            @Override
            public InputEvent getHotKey() {
                return null;
            }

            @Override
            public boolean onAction(IDE ide) {
                return proc.onAction(ide);
            }
        };
    }

    public static Action action(final String title, final InputEvent hotKey, final ActionProc proc) {
        NullCheck.notEmpty((Object)title, (String)"title");
        NullCheck.notNull((Object)hotKey, (String)"hotKey");
        NullCheck.notNull((Object)proc, (String)"proc");
        final String id = Sha1.getSha1((String)title, (String)"UTF-8");
        return new Action(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getTitle() {
                return title;
            }

            @Override
            public InputEvent getHotKey() {
                return hotKey;
            }

            @Override
            public boolean onAction(IDE ide) {
                return proc.onAction(ide);
            }
        };
    }

    public static Action[] actions(Action ... actions) {
        return actions;
    }

    public static interface ActionProc {
        public boolean onAction(IDE var1);
    }

    public static interface Action
    extends ActionProc {
        public String getId();

        public String getTitle();

        public InputEvent getHotKey();
    }
}

