/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.studio;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.studio.Conv;
import org.luwrain.app.studio.NewProjectLayout;
import org.luwrain.app.studio.PositionInfo;
import org.luwrain.app.studio.ProjectBaseLayout;
import org.luwrain.app.studio.ScriptExceptionWrapper;
import org.luwrain.app.studio.Strings;
import org.luwrain.app.studio.TextEditingLayout;
import org.luwrain.controls.MutableLinesImpl;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.Lines;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.queries.CurrentDirQuery;
import org.luwrain.script.core.ScriptCore;
import org.luwrain.studio.Editing;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Output;
import org.luwrain.studio.Project;
import org.luwrain.studio.Settings;
import org.luwrain.studio.TextEditing;
import org.luwrain.studio.proj.main.ProjectImpl;
import org.luwrain.studio.proj.single.SingleFileProject;

public final class App
extends AppBase<Strings> {
    private static final Logger log = LogManager.getLogger();
    private final String arg;
    final IDE ide = this.getIde();
    private Conv conv = null;
    private Settings sett = null;
    private ProjectBaseLayout projectBaseLayout = null;
    private TextEditingLayout textEditingLayout = null;
    private NewProjectLayout newProjectLayout = null;
    private ScriptCore scriptCore = null;
    private Project proj = null;
    private Object treeRoot = null;
    Editing editing = null;
    private final List<Editing> editings = new ArrayList<Editing>();
    private Object[] compilationOutput = new Object[0];
    private final MutableLinesImpl outputText = new MutableLinesImpl();

    public App() {
        this(null);
    }

    public App(String arg) {
        super(Strings.class, "luwrain.studio");
        this.setTabProcessing(false);
        this.arg = arg;
    }

    protected AreaLayout onAppInit() throws IOException {
        this.conv = new Conv(this);
        this.loadScriptCore();
        this.projectBaseLayout = new ProjectBaseLayout(this);
        this.newProjectLayout = new NewProjectLayout(this);
        this.treeRoot = ((Strings)this.getStrings()).treeRoot();
        this.setAppName(((Strings)this.getStrings()).appName());
        if (this.loadProjectByArg()) {
            return this.textEditingLayout != null ? this.textEditingLayout.getAreaLayout() : this.projectBaseLayout.getAreaLayout();
        }
        return this.newProjectLayout.getAreaLayout();
    }

    private boolean loadProjectByArg() throws IOException {
        if (this.arg == null || this.arg.isEmpty()) {
            return false;
        }
        if (this.arg.toUpperCase().endsWith(".lwrproj")) {
            return this.loadProject(new File(this.arg));
        }
        SingleFileProject singleFileProj = new SingleFileProject(this.getIde(), new File(this.arg));
        this.proj = singleFileProj;
        this.treeRoot = this.proj.getPartsRoot();
        this.projectBaseLayout.treeArea.requery();
        Editing editing = this.proj.getMainSourceFile().startEditing();
        this.editings.add(editing);
        this.textEditingLayout = new TextEditingLayout(this, this.projectBaseLayout, (TextEditing)editing);
        return true;
    }

    private boolean loadProject(File file) {
        if (!file.exists() || file.isDirectory()) {
            return false;
        }
        log.trace("Loading the project " + file.getAbsolutePath());
        TaskCancelling.TaskId taskId = this.newTaskId();
        return this.runTask(taskId, () -> {
            Project proj;
            try {
                proj = new ProjectImpl().load(file, this.getIde());
            }
            catch (Throwable ex) {
                log.catching(ex);
                this.getLuwrain().crash(ex);
                return;
            }
            if (proj == null) {
                log.error("No loaded project");
                return;
            }
            this.finishedTask(taskId, () -> this.activateProject(proj));
        });
    }

    private void loadScriptCore() throws IOException {
        this.scriptCore = new ScriptCore(this.getLuwrain());
        File scriptsDir = new File(this.getLuwrain().getPath("SYS_JS_DIR"));
        File[] scripts = scriptsDir.listFiles();
        if (scripts == null) {
            return;
        }
        for (File f : scripts) {
            if (f == null || !f.getName().startsWith("studio-")) continue;
            log.trace("Loading " + f.getAbsolutePath());
            this.scriptCore.load(f);
        }
    }

    private IDE getIde() {
        return new IDE(){

            @Override
            public ScriptCore getScriptCore() {
                return App.this.scriptCore;
            }

            public App getAppBase() {
                return App.this;
            }

            @Override
            public boolean loadProject(File file) {
                return App.this.loadProject(file);
            }

            @Override
            public Luwrain getLuwrainObj() {
                return App.this.getLuwrain();
            }

            @Override
            public Settings getSett() {
                return App.this.sett;
            }

            @Override
            public void onFoldersUpdate() {
                if (App.this.projectBaseLayout != null) {
                    App.this.projectBaseLayout.treeArea.refresh();
                }
            }

            @Override
            public void onEditingUpdate() {
                TextEditingLayout layout = App.this.textEditingLayout;
                if (layout == null) {
                    return;
                }
                App.this.getLuwrain().onAreaNewContent((Area)layout.editArea);
                App.this.getLuwrain().onAreaNewHotPoint((Area)layout.editArea);
            }

            @Override
            public void showWizard(LayoutBase wizardLayout) {
                NullCheck.notNull((Object)wizardLayout, (String)"wizardLayout");
                App.this.setAreaLayout(wizardLayout);
            }
        };
    }

    Layouts layouts() {
        return new Layouts(){

            @Override
            public void projectBase() {
                App.this.setAreaLayout(App.this.projectBaseLayout);
                App.this.getLuwrain().announceActiveArea();
            }
        };
    }

    void activateProject(Project proj) {
        NullCheck.notNull((Object)proj, (String)"proj");
        this.proj = proj;
        this.treeRoot = proj.getPartsRoot();
        if (this.treeRoot == null) {
            log.warn("No project tree root");
        }
        this.projectBaseLayout.treeArea.requery();
        this.layouts().projectBase();
    }

    void startEditing(Editing editing) throws IOException {
        NullCheck.notNull((Object)editing, (String)"editing");
        this.editings.removeIf(e -> editing.hasSameSource((Editing)e));
        this.editings.add(editing);
        if (editing instanceof TextEditing) {
            TextEditing t = (TextEditing)editing;
            this.textEditingLayout = new TextEditingLayout(this, this.projectBaseLayout, t);
            this.setAreaLayout(this.textEditingLayout);
            this.textEditingLayout.setActiveArea((Area)this.textEditingLayout.editArea);
        }
    }

    PositionInfo getCompilationOutputPositionInfo(int index) {
        if (this.compilationOutput == null || index < 0 || index >= this.compilationOutput.length) {
            return null;
        }
        Object obj = this.compilationOutput[index];
        if (!(obj instanceof ScriptExceptionWrapper)) {
            return null;
        }
        ScriptExceptionWrapper wrapper = (ScriptExceptionWrapper)obj;
        if (wrapper.ex.getLineNumber() <= 0) {
            return null;
        }
        return new PositionInfo(wrapper.ex.getFileName(), wrapper.ex.getLineNumber(), wrapper.ex.getColumnNumber());
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    public boolean onAreaQuery(Area area, AreaQuery query) {
        if (query.getQueryCode() == 5 && query instanceof CurrentDirQuery) {
            return this.onDirectoryQuery((CurrentDirQuery)query);
        }
        return super.onAreaQuery(area, query);
    }

    private boolean onDirectoryQuery(CurrentDirQuery query) {
        if (this.proj == null) {
            return false;
        }
        File f = new File("/tmp");
        if (f == null) {
            return false;
        }
        query.answer(f.getAbsolutePath());
        return true;
    }

    public void closeApp() {
        boolean hasUnsavedChanges = false;
        for (Editing e : this.editings) {
            if (!e.getModifiedFlag().get()) continue;
            hasUnsavedChanges = true;
            break;
        }
        if (hasUnsavedChanges) {
            switch (this.conv.unsavedChanges()) {
                case CANCEL: {
                    return;
                }
                case SAVE: {
                    for (Editing e : this.editings) {
                        if (!e.getModifiedFlag().get()) continue;
                        try {
                            e.save();
                        }
                        catch (IOException ex) {
                            this.crash(ex);
                            return;
                        }
                    }
                    break;
                }
            }
        }
        for (Editing e : this.editings) {
            e.closeEditing();
        }
        this.editings.clear();
        if (this.proj != null) {
            this.proj.close();
        }
        this.proj = null;
        super.closeApp();
    }

    Project getProject() {
        return this.proj;
    }

    Lines getOutputModel() {
        return new OutputModel();
    }

    Conv getConv() {
        return this.conv;
    }

    boolean isSingleFileProject() {
        return this.proj instanceof SingleFileProject;
    }

    TextEditingLayout getTextEditingLayout() {
        return this.textEditingLayout;
    }

    static interface Layouts {
        public void projectBase();
    }

    private final class OutputModel
    implements Lines {
        private OutputModel() {
        }

        public int getLineCount() {
            if (App.this.compilationOutput != null && App.this.compilationOutput.length > 0) {
                int count = App.this.compilationOutput.length;
                return count > 0 ? count : 1;
            }
            int count = App.this.outputText.getLineCount();
            return count > 0 ? count : 1;
        }

        public String getLine(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("index (" + index + ") may not be negative");
            }
            if (App.this.compilationOutput != null && App.this.compilationOutput.length > 0) {
                if (index >= App.this.compilationOutput.length) {
                    return "";
                }
                return App.this.compilationOutput[index].toString();
            }
            if (App.this.outputText.getLineCount() < 1) {
                return "";
            }
            return App.this.outputText.getLine(index);
        }
    }

    private final class OutputControl
    implements Output {
        private final Runnable listener;

        OutputControl(Runnable listener) {
            NullCheck.notNull((Object)listener, (String)"listener");
            this.listener = listener;
        }

        @Override
        public void reset(String[] lines) {
            NullCheck.notNullItems((Object[])lines, (String)"lines");
            App.this.outputText.setLines(lines);
            this.listener.run();
        }

        @Override
        public void addLine(String line) {
            this.listener.run();
            App.this.outputText.addLine(line);
        }
    }
}

