/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.i18n.ru;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.i18n.ru.RuWord;

public final class WordList {
    private static final String LOG_COMPONENT = "ru";
    private static final String RESOURCE_PATH = "org/luwrain/i18n/ru/words";
    static final Type RU_WORD_LIST_TYPE = new TypeToken<List<RuWord>>(){}.getType();
    private final Gson gson = new Gson();
    private final Map<String, List<RuWord>> words = new HashMap<String, List<RuWord>>();

    RuWord[] findWord(String lemma) {
        NullCheck.notEmpty((Object)lemma, (String)"lemma");
        List<RuWord> res = this.words.get(lemma.toUpperCase());
        if (res == null) {
            return new RuWord[0];
        }
        return res.toArray(new RuWord[res.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFromResource() {
        URL url = this.getClass().getClassLoader().getResource(RESOURCE_PATH);
        if (url == null) {
            Log.error((String)LOG_COMPONENT, (String)"No resource org/luwrain/i18n/ru/words");
            return;
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));){
            this.words.clear();
            List res = (List)this.gson.fromJson((Reader)r, RU_WORD_LIST_TYPE);
            if (res == null) {
                return;
            }
            for (RuWord w : res) {
                String lemma = w.getLemma().toUpperCase();
                if (lemma.isEmpty()) continue;
                List<RuWord> l = this.words.get(lemma);
                if (l == null) {
                    l = new LinkedList<RuWord>();
                    this.words.put(lemma, l);
                }
                w.init();
                l.add(w);
            }
        }
        catch (IOException e) {
            Log.error((String)LOG_COMPONENT, (String)("unable to read and parse the resource org/luwrain/i18n/ru/words:" + e.getClass().getName() + ":" + e.getMessage()));
            return;
        }
    }
}

