/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings.mail;

import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.cpanel.Element;
import org.luwrain.cpanel.Section;
import org.luwrain.cpanel.SimpleElement;
import org.luwrain.cpanel.SimpleSection;
import org.luwrain.cpanel.StandardElements;
import org.luwrain.settings.mail.Strings;
import org.luwrain.settings.mail.accounts.AccountElement;
import org.luwrain.settings.mail.accounts.AccountSection;
import org.luwrain.settings.mail.accounts.Accounts;
import org.luwrain.settings.mail.accounts.AccountsSection;

public final class Factory
implements org.luwrain.cpanel.Factory {
    private final Luwrain luwrain;
    private final SimpleElement mailElement;
    private final SimpleElement accountsElement;
    private final SimpleElement commonSettElement;
    private Strings strings = null;
    private Accounts accounts = null;

    public Factory(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
        this.mailElement = new SimpleElement(StandardElements.APPLICATIONS, this.getClass().getName());
        this.accountsElement = new SimpleElement((Element)this.mailElement, this.getClass().getName() + ":Accounts");
        this.commonSettElement = new SimpleElement((Element)this.mailElement, this.getClass().getName() + ":Settings");
    }

    public Element[] getElements() {
        if (!this.initStrings()) {
            return new Element[0];
        }
        return new Element[]{this.mailElement, this.accountsElement};
    }

    public Element[] getOnDemandElements(Element parent) {
        if (parent.equals(this.accountsElement)) {
            return this.accounts.getAccountsElements(parent);
        }
        return new Element[0];
    }

    public Section createSection(Element el) {
        if (el.equals(this.mailElement)) {
            return new SimpleSection((Element)this.mailElement, this.strings.mailSection());
        }
        if (el.equals(this.accountsElement)) {
            return new AccountsSection(this.accounts, el);
        }
        if (el instanceof AccountElement) {
            return new AccountSection(this.luwrain, this.accounts, (AccountElement)el);
        }
        return null;
    }

    private boolean initStrings() {
        Object o = this.luwrain.i18n().getStrings(Strings.class.getName());
        if (o != null && o instanceof Strings) {
            this.strings = (Strings)o;
            return true;
        }
        this.strings = null;
        return false;
    }
}

