/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.news.nitrite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.dizitart.no2.objects.Cursor;
import org.dizitart.no2.objects.ObjectFilter;
import org.dizitart.no2.objects.ObjectRepository;
import org.dizitart.no2.objects.filters.ObjectFilters;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.pim.PimException;
import org.luwrain.pim.news.NewsArticle;
import org.luwrain.pim.news.NewsArticles;
import org.luwrain.pim.news.NewsGroup;
import org.luwrain.pim.news.nitrite.Article;
import org.luwrain.pim.news.nitrite.Group;
import org.luwrain.pim.news.nitrite.Storing;

final class Articles
implements NewsArticles {
    private final Storing storing;
    private final ObjectRepository<Article> repo;

    Articles(Storing storing) {
        NullCheck.notNull((Object)storing, (String)"storing");
        this.storing = storing;
        this.repo = storing.storage.get();
    }

    @Override
    public void save(NewsGroup newsGroup, NewsArticle article) throws PimException {
        NullCheck.notNull((Object)newsGroup, (String)"newsGroup");
        Group g = (Group)newsGroup;
        try {
            this.storing.execInQueue(() -> {
                Article a = new Article();
                a.copyValues(article);
                a.setGroupId(g.id);
                a.genNewId();
                this.repo.insert((Object)a, (Object[])new Article[0]);
                return null;
            });
        }
        catch (Exception e) {
            throw new PimException(e);
        }
    }

    @Override
    public void delete(NewsGroup newsGroup, NewsArticle article) throws PimException {
        NullCheck.notNull((Object)newsGroup, (String)"newsGroup");
        Group g = (Group)newsGroup;
        try {
            this.storing.execInQueue(() -> {
                Article a = (Article)article;
                Log.debug((String)"proba", (String)("Deleting " + a.id));
                this.repo.remove(ObjectFilters.eq((String)"id", (Object)a.id));
                return null;
            });
        }
        catch (Exception e) {
            throw new PimException(e);
        }
    }

    @Override
    public NewsArticle[] load(NewsGroup group) {
        Group g = (Group)group;
        NullCheck.notNull((Object)group, (String)"group");
        try {
            return this.storing.execInQueue(() -> {
                ArrayList<Article> res = new ArrayList<Article>();
                Cursor c = this.repo.find(ObjectFilters.eq((String)"groupId", (Object)g.id));
                for (Article a : c) {
                    a.setStoring(this.storing, this.repo);
                    res.add(a);
                }
                return res.toArray(new Article[res.size()]);
            });
        }
        catch (Exception e) {
            throw new PimException(e);
        }
    }

    @Override
    public NewsArticle[] loadWithoutRead(NewsGroup newsGroup) {
        NullCheck.notNull((Object)newsGroup, (String)"newsGroup");
        Group g = (Group)newsGroup;
        try {
            return this.storing.execInQueue(() -> {
                ArrayList<Article> res = new ArrayList<Article>();
                Cursor c = this.repo.find(ObjectFilters.and((ObjectFilter[])new ObjectFilter[]{ObjectFilters.eq((String)"groupId", (Object)g.id), ObjectFilters.not((ObjectFilter)ObjectFilters.eq((String)"state", (Object)1))}));
                for (Article a : c) {
                    a.setStoring(this.storing, this.repo);
                    res.add(a);
                }
                return res.toArray(new Article[res.size()]);
            });
        }
        catch (Exception e) {
            throw new PimException(e);
        }
    }

    @Override
    public int countByUriInGroup(NewsGroup newsGroup, String uri) {
        NullCheck.notEmpty((Object)uri, (String)"uri");
        Group g = (Group)newsGroup;
        Cursor c = this.repo.find(ObjectFilters.and((ObjectFilter[])new ObjectFilter[]{ObjectFilters.eq((String)"uri", (Object)uri), ObjectFilters.eq((String)"groupId", (Object)g.id)}));
        return c.totalCount();
    }

    @Override
    public int countNewInGroup(NewsGroup group) throws PimException {
        NullCheck.notNull((Object)group, (String)"group");
        if (!(group instanceof Group)) {
            return 0;
        }
        Group g = (Group)group;
        try {
            return this.storing.execInQueue(() -> this.repo.find(ObjectFilters.and((ObjectFilter[])new ObjectFilter[]{ObjectFilters.eq((String)"groupId", (Object)g.id), ObjectFilters.eq((String)"state", (Object)0)})).totalCount());
        }
        catch (Exception e) {
            throw new PimException(e);
        }
    }

    @Override
    public int[] countNewInGroups(NewsGroup[] groups) throws PimException {
        NullCheck.notNullItems((Object[])groups, (String)"groups");
        Group[] g = (Group[])Arrays.copyOf(groups, groups.length, Group[].class);
        try {
            return this.storing.execInQueue(() -> {
                int[] res = new int[g.length];
                Arrays.fill(res, 0);
                Cursor c = this.repo.find(ObjectFilters.eq((String)"state", (Object)0));
                block0: for (Article a : c) {
                    for (int i = 0; i < g.length; ++i) {
                        if (a.getGroupId() != g[i].id) continue;
                        int n = i;
                        res[n] = res[n] + 1;
                        continue block0;
                    }
                }
                return res;
            });
        }
        catch (Exception e) {
            throw new PimException(e);
        }
    }

    @Override
    public int[] countMarkedInGroups(NewsGroup[] groups) {
        NullCheck.notNullItems((Object[])groups, (String)"groups");
        Group[] g = (Group[])Arrays.copyOf(groups, groups.length, Group[].class);
        try {
            return this.storing.execInQueue(() -> {
                int[] res = new int[g.length];
                Arrays.fill(res, 0);
                Cursor c = this.repo.find(ObjectFilters.eq((String)"state", (Object)2));
                block0: for (Article a : c) {
                    for (int i = 0; i < g.length; ++i) {
                        if (a.getGroupId() != g[i].id) continue;
                        int n = i;
                        res[n] = res[n] + 1;
                        continue block0;
                    }
                }
                return res;
            });
        }
        catch (Exception e) {
            throw new PimException(e);
        }
    }

    @Override
    public Set<String> loadUrisInGroup(NewsGroup group) {
        NullCheck.notNull((Object)group, (String)"group");
        Group g = (Group)group;
        try {
            return this.storing.execInQueue(() -> {
                HashSet<String> res = new HashSet<String>();
                for (Article a : this.repo.find(ObjectFilters.eq((String)"groupId", (Object)g.id))) {
                    res.add(a.getUri());
                }
                return res;
            });
        }
        catch (Exception e) {
            throw new PimException(e);
        }
    }
}

