/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.mail;

import java.nio.file.Path;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.luwrain.core.ObjFactory;
import org.luwrain.pim.mail.persistence.MailPersistence;
import org.luwrain.pim.mail.persistence.model.Account;
import org.luwrain.pim.mail.persistence.model.Folder;
import org.luwrain.pim.mail.persistence.model.MessageMetadata;
import org.luwrain.pim.storage.ExecQueues;

public final class MailFactory
implements ObjFactory,
AutoCloseable {
    private static final Logger log = LogManager.getLogger();
    final Path path;
    final ExecQueues queues = new ExecQueues();
    private final MVStore store;
    private final MVMap<Integer, Account> accountsMap;
    private final MVMap<Integer, Folder> foldersMap;
    private final MVMap<Long, MessageMetadata> messagesMap;
    private final MVMap<String, Long> keysMap;

    public MailFactory(Path path) {
        this.path = Objects.requireNonNull(path, "path can't be null");
        String dbFile = path.resolve("mail.mvdb").toString();
        log.trace("Opening the mail database in " + dbFile);
        this.store = MVStore.open((String)dbFile);
        this.messagesMap = this.store.openMap("messages");
        this.foldersMap = this.store.openMap("folders");
        this.accountsMap = this.store.openMap("accounts");
        this.keysMap = this.store.openMap("keys");
    }

    public String getExtObjName() {
        return MailPersistence.class.getName();
    }

    public Object newObject(String name) {
        return new MailPersistence(this.queues, this.accountsMap, this.foldersMap, this.messagesMap, this.keysMap);
    }

    @Override
    public void close() {
        this.queues.close();
    }
}

