/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.contacts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.contacts.App;
import org.luwrain.app.contacts.FoldersAppearance;
import org.luwrain.app.contacts.Strings;
import org.luwrain.controls.FormArea;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.controls.edit.DefaultEditAreaAppearance;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.events.InputEvent;
import org.luwrain.pim.contacts.Contact;
import org.luwrain.pim.contacts.ContactValue;
import org.luwrain.pim.contacts.Contacts;
import org.luwrain.pim.contacts.ContactsFolder;
import org.luwrain.pim.contacts.ContactsFolders;
import org.luwrain.popups.Popups;
import org.luwrain.popups.YesNoPopup;

final class MainLayout
extends LayoutBase
implements ListArea.ClickHandler {
    private final App app;
    private final ContactsFolders folders;
    private final Contacts contacts;
    final ListArea foldersArea;
    final FormArea valuesArea;
    final EditArea notesArea;
    private ContactsFolder openedFolder = null;
    private Contact openedContact = null;
    private final List items = new ArrayList();

    MainLayout(App app) {
        super((AppBase)app);
        this.app = app;
        this.openedFolder = app.getStoring().getFolders().getRoot();
        this.folders = app.getStoring().getFolders();
        this.contacts = app.getStoring().getContacts();
        this.updateItems();
        this.foldersArea = new ListArea(this.listParams(params -> {
            params.model = new ListUtils.ListModel(this.items);
            params.appearance = new FoldersAppearance(app);
            params.name = ((Strings)app.getStrings()).foldersAreaName();
            params.clickHandler = this;
        }));
        LayoutBase.Actions foldersActions = this.actions(new LayoutBase.ActionInfo[]{this.action("new-folder", "\u041d\u043e\u0432\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430", new InputEvent(InputEvent.Special.INSERT, EnumSet.of(InputEvent.Modifiers.SHIFT)), this::actNewFolder), this.action("new-contact", "\u041d\u043e\u0432\u044b\u0439 \u043a\u043e\u043d\u0442\u0430\u043a\u0442", new InputEvent(InputEvent.Special.INSERT), this::actNewContact)});
        this.valuesArea = new FormArea(this.getControlContext(), ((Strings)app.getStrings()).valuesAreaName());
        LayoutBase.Actions valuesActions = this.actions(new LayoutBase.ActionInfo[]{this.action("new-value", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", new InputEvent(InputEvent.Special.INSERT), this::actNewValue)});
        this.notesArea = new EditArea(this.editParams(params -> {
            params.name = ((Strings)app.getStrings()).notesAreaName();
            params.appearance = new DefaultEditAreaAppearance(this.getControlContext());
        }));
        LayoutBase.Actions notesActions = this.actions(new LayoutBase.ActionInfo[0]);
        this.setAreaLayout(AreaLayout.LEFT_TOP_BOTTOM, (Area)this.foldersArea, foldersActions, (Area)this.valuesArea, valuesActions, (Area)this.notesArea, notesActions);
    }

    public boolean onListClick(ListArea area, int index, Object obj) {
        if (obj == null || !(obj instanceof Contact)) {
            return false;
        }
        this.ensureEverythingSaved();
        this.openedContact = (Contact)obj;
        this.fillValuesArea(this.valuesArea);
        this.fillNotesArea(this.notesArea);
        this.setActiveArea((Area)this.valuesArea);
        return true;
    }

    private boolean actNewFolder() {
        String name = this.app.getConv().newFolderName();
        if (name == null || name.trim().isEmpty()) {
            return true;
        }
        ContactsFolder f = new ContactsFolder();
        f.setTitle(name.trim());
        this.folders.save(this.openedFolder, f);
        this.updateItems();
        return true;
    }

    private boolean actNewContact() {
        String name = this.app.getConv().newContactName();
        if (name == null || name.trim().isEmpty()) {
            return true;
        }
        Contact c = new Contact();
        c.setTitle(name);
        this.contacts.save(this.openedFolder, c);
        this.updateItems();
        return true;
    }

    private boolean actNewValue() {
        if (this.openedContact == null) {
            return false;
        }
        ContactValue.Type type = this.app.getConv().newContactValueType();
        if (type == null) {
            return true;
        }
        ContactValue newValue = new ContactValue();
        newValue.setType(type);
        ContactValue[] oldValues = this.openedContact.getValues();
        ContactValue[] newValues = Arrays.copyOf(oldValues, oldValues.length + 1);
        newValues[newValues.length - 1] = newValue;
        this.openedContact.setValues(newValues);
        return true;
    }

    private void updateItems() {
        this.items.clear();
        this.items.addAll(Arrays.asList(this.folders.load(this.openedFolder)));
        this.items.addAll(Arrays.asList(this.contacts.load(this.openedFolder)));
    }

    private void fillValuesArea(FormArea area) {
        NullCheck.notNull((Object)area, (String)"area");
        area.clear();
        if (this.openedContact == null) {
            return;
        }
        area.addEdit("name", "\u0418\u043c\u044f:", this.openedContact.getTitle(), null, true);
        int counter = 1;
        for (ContactValue v : this.openedContact.getValues()) {
            if (v.getType() != ContactValue.Type.MAIL) continue;
            area.addEdit("mail" + counter++, "\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430:", v.getValue(), (Object)v, true);
        }
        for (ContactValue v : this.openedContact.getValues()) {
            if (v.getType() != ContactValue.Type.PHONE) continue;
            area.addEdit("mobile" + counter++, "\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d:", v.getValue(), (Object)v, true);
        }
        for (ContactValue v : this.openedContact.getValues()) {
            if (v.getType() != ContactValue.Type.ADDRESS) continue;
            area.addEdit("address" + counter++, "\u0410\u0434\u0440\u0435\u0441:", v.getValue(), (Object)v, true);
        }
        for (ContactValue v : this.openedContact.getValues()) {
            if (v.getType() != ContactValue.Type.BIRTHDAY) continue;
            area.addEdit("birthday" + counter++, "\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f:", v.getValue(), (Object)v, true);
        }
        for (ContactValue v : this.openedContact.getValues()) {
            if (v.getType() != ContactValue.Type.SKYPE) continue;
            area.addEdit("skype" + counter++, "Skype:", v.getValue(), (Object)v, true);
        }
    }

    private void saveForm(FormArea area) {
        if (this.openedContact == null) {
            return;
        }
        ArrayList<ContactValue> values = new ArrayList<ContactValue>();
        for (int i = 0; i < area.getItemCount(); ++i) {
            Object obj = area.getItemObj(i);
            if (obj == null || !(obj instanceof ContactValue)) continue;
            ContactValue value = (ContactValue)obj;
            value.setValue(area.getEnteredText(i));
            if (value.getValue().trim().isEmpty()) continue;
            values.add(value);
        }
        this.openedContact.setValues(values.toArray(new ContactValue[values.size()]));
    }

    private boolean fillNotesArea(EditArea area) {
        String value = this.openedContact.getNotes();
        area.setText(value.split("\n", -1));
        return true;
    }

    private boolean saveNotes(EditArea area) {
        if (this.openedContact == null) {
            return true;
        }
        StringBuilder b = new StringBuilder();
        int count = area.getLineCount();
        if (count > 0) {
            b.append(area.getLine(0));
            for (int i = 1; i < count; ++i) {
                b.append("\n" + area.getLine(i));
            }
        }
        this.openedContact.setNotes(b.toString());
        return true;
    }

    private boolean deleteFolder(ContactsFolder folder) {
        if (folder.isRoot()) {
            this.app.getLuwrain().message("\u041a\u043e\u0440\u043d\u0435\u0432\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d\u0430", Luwrain.MessageType.ERROR);
            return false;
        }
        Contact[] contacts = this.app.getStoring().getContacts().load(folder);
        ContactsFolder[] subfolders = this.app.getStoring().getFolders().load(folder);
        if (contacts != null && contacts.length > 0) {
            this.app.getLuwrain().message("\u0412\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u044b \u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d\u0430", Luwrain.MessageType.ERROR);
            return false;
        }
        if (subfolders != null && subfolders.length > 0) {
            this.app.getLuwrain().message("\u0412\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d\u0430", Luwrain.MessageType.ERROR);
            return false;
        }
        YesNoPopup popup = new YesNoPopup(this.app.getLuwrain(), "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432", "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432 \"" + folder.getTitle() + "\"?", false, Popups.DEFAULT_POPUP_FLAGS);
        this.app.getLuwrain().popup((Popup)popup);
        if (popup.wasCancelled() || !popup.result()) {
            return false;
        }
        this.app.getStoring().getFolders().delete(folder);
        return true;
    }

    private boolean deleteContact(Contact contact) {
        YesNoPopup popup = new YesNoPopup(this.app.getLuwrain(), "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432", "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442 \"" + contact.getTitle() + "\"?", false, Popups.DEFAULT_POPUP_FLAGS);
        this.app.getLuwrain().popup((Popup)popup);
        if (popup.wasCancelled() || !popup.result()) {
            return false;
        }
        this.app.getStoring().getContacts().delete(contact);
        this.openedContact = null;
        return true;
    }

    void ensureEverythingSaved() {
        if (this.openedContact == null) {
            return;
        }
        this.saveForm(this.valuesArea);
        this.saveNotes(this.notesArea);
    }
}

