/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.wiki;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.wiki.Config;
import org.luwrain.app.wiki.Conversations;
import org.luwrain.app.wiki.MainLayout;
import org.luwrain.app.wiki.Server;
import org.luwrain.app.wiki.Strings;
import org.luwrain.core.Application;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Log;
import org.luwrain.core.MonoApp;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.io.api.mediawiki.Mediawiki;
import org.luwrain.io.api.mediawiki.Page;

public final class App
extends AppBase<Strings>
implements MonoApp {
    private static final String LOG_COMPONENT = "wiki";
    private static final String SETTINGS_PATH = "/org/luwrain/app/wiki";
    private final Gson gson = new Gson();
    private Config conf = null;
    private final String arg;
    final List<Server> servers = new ArrayList<Server>();
    final List<Page> pages = new ArrayList<Page>();
    private Conversations conv = null;
    private MainLayout mainLayout = null;

    public App() {
        this(null);
    }

    public App(String arg) {
        super(Strings.class, "luwrain.wiki");
        this.arg = arg;
    }

    protected AreaLayout onAppInit() {
        this.conf = (Config)this.getLuwrain().loadConf(Config.class);
        if (this.conf == null) {
            this.conf = new Config();
            this.getLuwrain().saveConf((Object)this.conf);
        }
        if (this.conf.servers != null) {
            this.servers.addAll(this.conf.servers);
        }
        for (Server s : this.servers) {
            if (s.name == null || s.name.trim().isEmpty()) {
                s.name = ((Strings)this.getStrings()).defaultServerName();
            }
            if (s.searchUrl == null || s.searchUrl.trim().isEmpty()) {
                s.searchUrl = "https://en.wikipedia.org/w";
            }
            if (s.pagesUrl == null || s.pagesUrl.trim().isEmpty()) {
                s.pagesUrl = s.searchUrl;
            }
            s.name = s.name.trim();
            s.searchUrl = s.searchUrl.trim();
            s.pagesUrl = s.pagesUrl.trim();
        }
        this.conv = new Conversations(this);
        this.mainLayout = new MainLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        return this.mainLayout.getAreaLayout();
    }

    boolean search(String query) {
        NullCheck.notEmpty((Object)query, (String)"query");
        TaskCancelling.TaskId taskId = this.newTaskId();
        return this.runTask(taskId, () -> {
            ArrayList<Page> res = new ArrayList<Page>();
            for (Server s : this.servers) {
                Mediawiki m = new Mediawiki(s.searchUrl);
                try {
                    res.addAll(Arrays.asList(m.search(query)));
                }
                catch (Exception e) {
                    Log.error((String)LOG_COMPONENT, (String)("unable to fetch wiki pages from " + s.searchUrl));
                }
            }
            this.finishedTask(taskId, () -> {
                this.pages.clear();
                this.pages.addAll(res);
                this.getLuwrain().playSound(Sounds.OK);
                if (this.mainLayout != null) {
                    this.mainLayout.area.refresh();
                }
            });
        });
    }

    void saveServers() {
        this.conf.servers = this.servers;
        this.getLuwrain().saveConf((Object)this.conf);
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    public MonoApp.Result onMonoAppSecondInstance(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        this.mainLayout.area.moveHotPointToInput();
        return MonoApp.Result.BRING_FOREGROUND;
    }

    Conversations getConv() {
        return this.conv;
    }
}

