/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.news;

import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.news.App;
import org.luwrain.app.news.GroupWrapper;
import org.luwrain.app.news.PropertiesLayout;
import org.luwrain.app.news.Strings;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.controls.reader.ReaderArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.pim.news.NewsArticle;
import org.luwrain.pim.news.NewsGroup;
import org.luwrain.reader.Document;
import org.luwrain.reader.DocumentBuilder;
import org.luwrain.reader.DocumentBuilderLoader;

final class MainLayout
extends LayoutBase {
    final App app;
    final ListArea<GroupWrapper> groupsArea;
    final ListArea<NewsArticle> summaryArea;
    final ReaderArea viewArea;

    MainLayout(final App app) {
        super((AppBase)app);
        this.app = app;
        this.groupsArea = new ListArea<GroupWrapper>(this.listParams(params -> {
            params.name = ((Strings)app.getStrings()).groupsAreaName();
            params.model = new ListUtils.ListModel<GroupWrapper>(app.groups){

                public void refresh() {
                    app.loadGroups();
                }
            };
            params.appearance = new ListUtils.DefaultAppearance(params.context, Suggestions.CLICKABLE_LIST_ITEM);
            params.clickHandler = (area, index, group) -> this.onGroupsClick((GroupWrapper)group);
        })){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.BROADCAST) {
                    switch (event.getCode()) {
                        case REFRESH: {
                            if (event.getBroadcastFilterUniRef().startsWith("newsgroup:")) {
                                this.refresh();
                            }
                            return true;
                        }
                    }
                    super.onSystemEvent(event);
                }
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case PROPERTIES: {
                            return MainLayout.this.editGroupProps();
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        LayoutBase.Actions groupsActions = this.actions(new LayoutBase.ActionInfo[]{this.action("show-read", ((Strings)app.getStrings()).actionShowWithReadOnly(), new InputEvent('='), () -> this.setShowAllGroupsMode(true)), this.action("hide-read", ((Strings)app.getStrings()).actionHideWithReadOnly(), new InputEvent('-'), () -> this.setShowAllGroupsMode(false)), this.action("delete-group", ((Strings)app.getStrings()).actionDeleteGroup(), new InputEvent(InputEvent.Special.DELETE, EnumSet.of(InputEvent.Modifiers.SHIFT)), this::actDeleteGroup), this.action("add-group", ((Strings)app.getStrings()).actionAddGroup(), new InputEvent(InputEvent.Special.INSERT), this::actNewGroup)});
        this.summaryArea = new ListArea<NewsArticle>(this.listParams(params -> {
            params.name = ((Strings)app.getStrings()).summaryAreaName();
            params.model = new ListUtils.ListModel(app.articles);
            params.appearance = new SummaryAppearance();
            params.clickHandler = (area, index, article) -> this.onSummaryClick((NewsArticle)article);
            params.flags.add(ListArea.Flags.AREA_ANNOUNCE_SELECTED);
        })){

            public boolean onInputEvent(InputEvent event) {
                if (!event.isModified() && !event.isSpecial()) {
                    switch (event.getChar()) {
                        case ' ': {
                            return MainLayout.this.onSummarySpace();
                        }
                    }
                }
                return super.onInputEvent(event);
            }

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case OK: {
                            return MainLayout.this.openArticleUrl();
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        LayoutBase.Actions summaryActions = this.actions(new LayoutBase.ActionInfo[0]);
        ReaderArea.Params viewParams = new ReaderArea.Params();
        viewParams.context = this.getControlContext();
        this.viewArea = new ReaderArea(viewParams){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case OK: {
                            return false;
                        }
                    }
                }
                return super.onSystemEvent(event);
            }

            public String getAreaName() {
                return ((Strings)app.getStrings()).viewAreaName();
            }
        };
        LayoutBase.Actions viewActions = this.actions(new LayoutBase.ActionInfo[0]);
        this.setAreaLayout(AreaLayout.LEFT_TOP_BOTTOM, (Area)this.groupsArea, groupsActions, (Area)this.summaryArea, summaryActions, (Area)this.viewArea, viewActions);
    }

    private boolean actMarkAsReadWholeGroup() {
        GroupWrapper wrapper = (GroupWrapper)this.groupsArea.selected();
        if (wrapper == null) {
            return false;
        }
        NewsGroup group = wrapper.group;
        NewsArticle[] articles = this.app.getStoring().getArticles().loadWithoutRead(group);
        if (articles == null) {
            return true;
        }
        for (NewsArticle a : articles) {
            if (a.getState() != 0) continue;
            a.setState(1);
            a.save();
        }
        return true;
    }

    private boolean onGroupsClick(GroupWrapper group) {
        NullCheck.notNull((Object)group, (String)"group");
        this.app.openGroup(group.group);
        this.summaryArea.reset(false);
        this.summaryArea.refresh();
        this.setActiveArea((Area)this.summaryArea);
        return true;
    }

    private boolean actNewGroup() {
        String name = this.app.getConv().newGroupName();
        if (name == null) {
            return false;
        }
        NewsGroup group = new NewsGroup();
        group.setName(name);
        this.app.getStoring().getGroups().save(group);
        this.app.showAllGroups = true;
        this.app.loadGroups();
        this.groupsArea.refresh();
        for (GroupWrapper g : this.app.groups) {
            if (!g.group.getName().equals(name)) continue;
            this.groupsArea.select((Object)g, true);
            break;
        }
        return true;
    }

    private boolean actDeleteGroup() {
        GroupWrapper wrapper = (GroupWrapper)this.groupsArea.selected();
        if (wrapper == null) {
            return false;
        }
        if (!this.app.getConv().confirmGroupDeleting(wrapper)) {
            return true;
        }
        this.app.getStoring().getGroups().delete(wrapper.group);
        this.app.loadGroups();
        this.groupsArea.refresh();
        return true;
    }

    private boolean openArticleUrl() {
        NewsArticle article = (NewsArticle)this.summaryArea.selected();
        if (article == null) {
            return false;
        }
        this.markAsRead(article);
        String url = article.getUrl();
        if (url == null || url.trim().isEmpty()) {
            return false;
        }
        this.app.getLuwrain().launchApp("reader", new String[]{url.trim()});
        return true;
    }

    private boolean editGroupProps() {
        GroupWrapper wrapper = (GroupWrapper)this.groupsArea.selected();
        if (wrapper == null) {
            return false;
        }
        PropertiesLayout propLayout = new PropertiesLayout(this.app, wrapper.group, () -> {
            this.app.setAreaLayout(this);
            this.app.getLuwrain().announceActiveArea();
            this.groupsArea.refresh();
            return true;
        });
        this.app.setAreaLayout(propLayout);
        this.app.getLuwrain().announceActiveArea();
        return true;
    }

    private boolean onSummarySpace() {
        NewsArticle article = (NewsArticle)this.summaryArea.selected();
        if (article == null) {
            return false;
        }
        if (!this.markAsRead(article)) {
            return false;
        }
        this.summaryArea.refresh();
        this.groupsArea.refresh();
        int index = this.summaryArea.selectedIndex();
        if (index + 1 >= this.summaryArea.getListModel().getItemCount()) {
            this.setActiveArea((Area)this.groupsArea);
        } else {
            this.summaryArea.select(index + 1, true);
        }
        return true;
    }

    private boolean onSummaryClick(NewsArticle article) {
        NullCheck.notNull((Object)article, (String)"article");
        DocumentBuilder docBuilder = new DocumentBuilderLoader().newDocumentBuilder(this.getLuwrain(), "text/html");
        if (docBuilder == null) {
            return false;
        }
        this.markAsRead(article);
        this.summaryArea.refresh();
        this.groupsArea.refresh();
        Properties props = new Properties();
        props.setProperty("url", article.getUrl());
        Document doc = docBuilder.buildDoc(article.getContent(), props);
        if (doc != null) {
            doc.commit();
            this.viewArea.setDocument(doc, this.getAreaVisibleWidth((Area)this.viewArea));
        }
        this.setActiveArea((Area)this.viewArea);
        return true;
    }

    private boolean markAsRead(NewsArticle article) {
        NullCheck.notNull((Object)article, (String)"article");
        if (article.getState() == 0) {
            article.setState(1);
            article.save();
        }
        return true;
    }

    boolean setShowAllGroupsMode(boolean value) {
        this.app.showAllGroups = value;
        this.groupsArea.refresh();
        this.app.getLuwrain().playSound(Sounds.OK);
        return true;
    }

    final class SummaryAppearance
    implements ListArea.Appearance<NewsArticle> {
        SummaryAppearance() {
        }

        public void announceItem(NewsArticle article, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)article, (String)"article");
            NullCheck.notNull(flags, (String)"flags");
            String title = MainLayout.this.getLuwrain().getSpeakableText(article.getTitle(), Luwrain.SpeakableTextType.NATURAL);
            if (flags.contains(ListArea.Appearance.Flags.BRIEF)) {
                MainLayout.this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.LIST_ITEM, (String)title));
                return;
            }
            switch (article.getState()) {
                case 1: {
                    MainLayout.this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.LIST_ITEM, (String)(((Strings)MainLayout.this.app.getStrings()).readPrefix() + " " + title + " " + MainLayout.this.app.getI18n().getPastTimeBrief(article.getPublishedDate()))));
                    break;
                }
                case 2: {
                    MainLayout.this.app.setEventResponse(DefaultEventResponse.text((String)(((Strings)MainLayout.this.app.getStrings()).markedPrefix() + " " + title + " " + MainLayout.this.app.getI18n().getPastTimeBrief(article.getPublishedDate()))));
                    break;
                }
                default: {
                    MainLayout.this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.LIST_ITEM, (String)(title + " " + MainLayout.this.app.getI18n().getPastTimeBrief(article.getPublishedDate()))));
                }
            }
        }

        public String getScreenAppearance(NewsArticle article, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)article, (String)"article");
            NullCheck.notNull(flags, (String)"flags");
            switch (article.getState()) {
                case 0: {
                    return " [" + article.getTitle() + "]";
                }
                case 2: {
                    return "* " + article.getTitle();
                }
            }
            return "  " + article.getTitle();
        }

        public int getObservableLeftBound(NewsArticle article) {
            return 2;
        }

        public int getObservableRightBound(NewsArticle article) {
            return article.getTitle().length() + 2;
        }
    }
}

