/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader;

import org.luwrain.core.NullCheck;
import org.luwrain.reader.ExtraInfo;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.Run;
import org.luwrain.reader.TextAttr;

public class TextRun
implements Run {
    private String text = "";
    private String href = "";
    private TextAttr textAttr = new TextAttr();
    private Object associatedObject = null;
    private Paragraph parentPara;
    public ExtraInfo extraInfo = null;

    public TextRun(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        this.text = text;
    }

    public TextRun(String text, String href) {
        NullCheck.notNull((Object)text, (String)"text");
        this.text = text;
        this.href = href;
    }

    public TextRun(String text, String href, ExtraInfo extraInfo) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)href, (String)"href");
        this.text = text;
        this.href = href;
        this.extraInfo = extraInfo;
    }

    @Override
    public String text() {
        return this.text != null ? this.text : "";
    }

    @Override
    public boolean isEmpty() {
        return this.text == null || this.text.isEmpty();
    }

    @Override
    public String href() {
        return this.href != null ? this.href : "";
    }

    @Override
    public TextAttr textAttr() {
        return this.textAttr;
    }

    public String toString() {
        return this.text != null ? this.text : "";
    }

    @Override
    public void prepareText() {
        StringBuilder b = new StringBuilder();
        boolean wasSpace = false;
        for (int i = 0; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c == '\n' || c == '\t' || c == '\u00a0') {
                c = ' ';
            }
            if (Character.isISOControl(c) || wasSpace && Character.isSpace(c)) continue;
            b.append(c);
            wasSpace = Character.isSpace(c);
        }
        this.text = new String(b);
    }

    @Override
    public ExtraInfo extraInfo() {
        return this.extraInfo;
    }

    @Override
    public void setParentNode(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        if (!(node instanceof Paragraph)) {
            throw new IllegalArgumentException("node must be an instance of Paragraph");
        }
        this.parentPara = (Paragraph)node;
    }

    @Override
    public Node getParentNode() {
        return this.parentPara;
    }

    public Object getAssociatedObject() {
        return this.associatedObject;
    }

    public void setAssociatedObject(Object associatedObject) {
        this.associatedObject = associatedObject;
    }
}

