/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader;

import java.util.Arrays;
import java.util.LinkedList;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.EmptyLine;
import org.luwrain.reader.ExtraInfo;
import org.luwrain.reader.ListItem;
import org.luwrain.reader.Table;
import org.luwrain.reader.view.NodeBase;

public class Node
extends NodeBase {
    public static final int IMPORTANCE_REGULAR = 0;
    protected final Type type;
    protected Node[] subnodes = new Node[0];
    private Node parentNode = null;
    int level = 0;
    private Boolean allSubnodesSingleLineCache = null;
    public ExtraInfo extraInfo = null;
    protected int importance = 0;
    protected boolean empty = false;

    Node(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    protected void setParentNode(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        this.parentNode = node;
    }

    public final Node[] getSubnodes() {
        return this.subnodes != null ? (Node[])this.subnodes.clone() : new Node[]{};
    }

    public void setSubnodes(Node[] subnodes) {
        NullCheck.notNullItems((Object[])subnodes, (String)"subnodes");
        this.subnodes = (Node[])subnodes.clone();
    }

    public final Node getSubnode(int index) {
        if (this.subnodes == null) {
            throw new RuntimeException("No subnodes");
        }
        return this.subnodes[index];
    }

    public final int getSubnodeCount() {
        return this.subnodes != null ? this.subnodes.length : 0;
    }

    public final boolean noSubnodes() {
        return this.subnodes == null || this.subnodes.length < 1;
    }

    void preprocess() {
        if (this.subnodes == null) {
            this.subnodes = new Node[0];
        }
        if (this.type == Type.ROOT) {
            this.parentNode = null;
            if (this.subnodes.length != 0 && !(this.subnodes[this.subnodes.length - 1] instanceof EmptyLine)) {
                this.subnodes = Arrays.copyOf(this.subnodes, this.subnodes.length + 1);
                this.subnodes[this.subnodes.length - 1] = new EmptyLine();
            }
        }
        for (Node n : this.subnodes) {
            n.setParentNode(this);
            n.preprocess();
        }
        if (this.type == Type.ORDERED_LIST || this.type == Type.UNORDERED_LIST) {
            this.arrangeListItems();
        }
    }

    void setEmptyMark() {
        this.empty = true;
        if (this.importance < 0) {
            return;
        }
        if (this.subnodes == null || this.subnodes.length < 1) {
            return;
        }
        for (Node n : this.subnodes) {
            n.setEmptyMark();
            if (n.empty) continue;
            this.empty = false;
        }
    }

    int prune() {
        if (this.subnodes == null) {
            return 0;
        }
        int k = 0;
        for (int i = 0; i < this.subnodes.length; ++i) {
            if (this.subnodes[i].empty) {
                ++k;
                continue;
            }
            this.subnodes[i - k] = this.subnodes[i];
        }
        if (k > 0) {
            this.subnodes = Arrays.copyOf(this.subnodes, this.subnodes.length - k);
        }
        for (Node n : this.subnodes) {
            k += n.prune();
        }
        return k;
    }

    public String toString() {
        if (this.type == null) {
            return "";
        }
        return this.type.toString() + " \"" + this.getCompleteText() + "\"";
    }

    public final boolean hasNodeInAllParents(Node toCheck) {
        NullCheck.notNull((Object)toCheck, (String)"toCheck");
        for (Node p = this.getParentNode(); p != null; p = p.getParentNode()) {
            if (p != toCheck) continue;
            return true;
        }
        return false;
    }

    public final boolean isInTable(Table table) {
        for (Node p = this.getParentNode(); p != null; p = p.getParentNode()) {
            if (!(p instanceof Table)) continue;
            if (table == null) {
                return true;
            }
            if ((Table)p != table) continue;
            return true;
        }
        return false;
    }

    public String getCompleteText() {
        if (this.subnodes == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Node n : this.subnodes) {
            String value = n.getCompleteText();
            if (value.isEmpty()) continue;
            if (!first) {
                b.append(" ");
            }
            first = false;
            b.append(value);
        }
        return new String(b);
    }

    public boolean noText() {
        return this.getCompleteText().isEmpty();
    }

    public Type getParentType() {
        return this.parentNode != null && this.parentNode.subnodes != null ? this.parentNode.type : null;
    }

    int getParentSubnodeCount() {
        return this.parentNode != null && this.parentNode.subnodes != null ? this.parentNode.subnodes.length : -1;
    }

    public int getIndexInParentSubnodes() {
        if (this.parentNode == null || this.parentNode.subnodes == null) {
            return -1;
        }
        for (int i = 0; i < this.parentNode.subnodes.length; ++i) {
            if (this.parentNode.subnodes[i] != this) continue;
            return i;
        }
        return -1;
    }

    public int getImportance() {
        return this.importance;
    }

    public void setImportance(int importance) {
        this.importance = importance;
    }

    public void addSubnode(Node subnode) {
        NullCheck.notNull((Object)subnode, (String)"subnode");
        if (this.subnodes == null) {
            this.subnodes = new Node[]{subnode};
            return;
        }
        this.subnodes = Arrays.copyOf(this.subnodes, this.subnodes.length + 1);
        this.subnodes[this.subnodes.length - 1] = subnode;
    }

    protected void arrangeListItems() {
        NullCheck.notNullItems((Object[])this.subnodes, (String)"subnodes");
        LinkedList<Node> nodes = new LinkedList<Node>();
        LinkedList<Node> nextNodes = new LinkedList<Node>();
        for (int i = 0; i < this.subnodes.length; ++i) {
            Node n = this.subnodes[i];
            if (!(this.subnodes[i] instanceof ListItem)) {
                Log.warning((String)"doctree", (String)("subnode of type " + String.valueOf((Object)this.subnodes[i].type) + " found inside of a list"));
                nextNodes.add(n);
                continue;
            }
            if (!nextNodes.isEmpty()) {
                ListItem item = new ListItem();
                item.setSubnodes(nextNodes.toArray(new Node[nextNodes.size()]));
                nextNodes.clear();
                item.parentNode = this;
                for (Node k : item.getSubnodes()) {
                    k.parentNode = item;
                }
                nodes.add(item);
            }
            nodes.add(n);
        }
        if (!nextNodes.isEmpty()) {
            ListItem item = new ListItem();
            item.setSubnodes(nextNodes.toArray(new Node[nextNodes.size()]));
            nextNodes.clear();
            item.parentNode = this;
            for (Node k : item.getSubnodes()) {
                k.parentNode = item;
            }
            nodes.add(item);
        }
        for (Node n : this.subnodes = nodes.toArray(new Node[nodes.size()])) {
            n.preprocess();
        }
    }

    public boolean allSubnodesSingleLine() {
        if (this.allSubnodesSingleLineCache != null) {
            return this.allSubnodesSingleLineCache;
        }
        for (Node n : this.getSubnodes()) {
            if (n.getNodeHeight() <= 1) continue;
            this.allSubnodesSingleLineCache = new Boolean(false);
            return false;
        }
        this.allSubnodesSingleLineCache = new Boolean(true);
        return true;
    }

    public static enum Type {
        ROOT,
        SECTION,
        PARAGRAPH,
        TABLE,
        TABLE_ROW,
        TABLE_CELL,
        UNORDERED_LIST,
        ORDERED_LIST,
        LIST_ITEM;

    }
}

