/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.reader.view;

import org.luwrain.controls.reader.view.Row;
import org.luwrain.controls.reader.view.View;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.Run;

public final class Iterator {
    protected final View view;
    protected final Paragraph[] paragraphs;
    protected final Row[] rows;
    protected int current = 0;

    public Iterator(View view) {
        NullCheck.notNull((Object)view, (String)"view");
        this.view = view;
        this.paragraphs = view.getParagraphs();
        NullCheck.notNullItems((Object[])this.paragraphs, (String)"paragraphs");
        this.rows = view.getRows();
        NullCheck.notNullItems((Object[])this.rows, (String)"rows");
        this.current = 0;
    }

    public Iterator(View view, int initialPos) {
        NullCheck.notNull((Object)view, (String)"view");
        this.view = view;
        this.paragraphs = view.getParagraphs();
        NullCheck.notNull((Object)this.paragraphs, (String)"paragraphs");
        this.rows = view.getRows();
        NullCheck.notNull((Object)this.rows, (String)"rows");
        if (initialPos < 0 || initialPos >= this.rows.length) {
            throw new IllegalArgumentException("INvalid row initialPos (" + initialPos + "), row count is " + this.rows.length);
        }
        this.current = initialPos;
    }

    public boolean noContent() {
        return this.rows.length == 0;
    }

    public int getIndex() {
        if (this.noContent()) {
            return -1;
        }
        return this.current;
    }

    public int getCount() {
        return this.rows.length;
    }

    public View getView() {
        return this.view;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Iterator)) {
            return false;
        }
        Iterator it = (Iterator)o;
        return this.current == it.current;
    }

    public Iterator clone() {
        return new Iterator(this.view, this.current);
    }

    public boolean canMoveNext() {
        if (this.noContent()) {
            return false;
        }
        return this.current + 1 < this.rows.length;
    }

    public boolean canMovePrev() {
        if (this.noContent()) {
            return false;
        }
        return this.current > 0;
    }

    public boolean moveNext() {
        if (!this.canMoveNext()) {
            return false;
        }
        ++this.current;
        return true;
    }

    public boolean movePrev() {
        if (!this.canMovePrev()) {
            return false;
        }
        --this.current;
        return true;
    }

    public void moveEnd() {
        this.current = this.rows.length > 0 ? this.rows.length - 1 : 0;
    }

    public void moveBeginning() {
        this.current = 0;
    }

    public boolean searchForward(Matching matching) {
        NullCheck.notNull((Object)matching, (String)"matching");
        if (this.noContent()) {
            return false;
        }
        return this.searchForward(matching, 0);
    }

    public boolean searchForward(Matching matching, int searchFrom) {
        NullCheck.notNull((Object)matching, (String)"matching");
        if (searchFrom < 0) {
            throw new IllegalArgumentException("searchFrom (" + searchFrom + ") may not be negative");
        }
        if (this.noContent()) {
            return false;
        }
        return this.search(matching, searchFrom, 1);
    }

    public boolean searchBackward(Matching matching) {
        NullCheck.notNull((Object)matching, (String)"matching");
        if (this.noContent()) {
            return false;
        }
        return this.searchBackward(matching, this.rows.length - 1);
    }

    public boolean searchBackward(Matching matching, int searchFrom) {
        NullCheck.notNull((Object)matching, (String)"matching");
        if (searchFrom < 0) {
            throw new IllegalArgumentException("searchFrom (" + searchFrom + ") may not be negative");
        }
        if (this.noContent()) {
            return false;
        }
        return this.search(matching, searchFrom, -1);
    }

    protected boolean search(Matching matching, int searchFrom, int step) {
        NullCheck.notNull((Object)matching, (String)"matching");
        if (searchFrom < 0) {
            throw new IllegalArgumentException("searchFrom (" + searchFrom + ") may not be negative");
        }
        if (this.noContent()) {
            return false;
        }
        for (int i = searchFrom; i >= 0 && i < this.rows.length; i += step) {
            Row row = this.rows[i];
            Run firstRun = row.getFirstRun();
            if (!(firstRun.getParentNode() instanceof Paragraph)) {
                throw new RuntimeException("Row " + i + " isn't a title row, but its parent isn't a paragraph");
            }
            Paragraph para = (Paragraph)firstRun.getParentNode();
            Node node = para.getParentNode();
            if (!matching.isRowMatching(node, para, row)) continue;
            this.current = i;
            return true;
        }
        return false;
    }

    public String getText() {
        if (this.noContent()) {
            return "";
        }
        Row row = this.rows[this.current];
        return row.getText();
    }

    public int getIndexInParagraph() {
        if (this.noContent()) {
            return -1;
        }
        return this.getRow().getRelNum();
    }

    public boolean isParagraphBeginning() {
        return this.getIndexInParagraph() == 0;
    }

    public boolean hasRunOnRow(Run run) {
        Run[] runs;
        NullCheck.notNull((Object)run, (String)"run");
        for (Run r : runs = this.getRow().getRuns()) {
            if (run != r) continue;
            return true;
        }
        return false;
    }

    public Run[] getRuns() {
        if (this.noContent()) {
            return new Run[0];
        }
        return this.getRow().getRuns();
    }

    public int runBeginsAt(Run run) {
        NullCheck.notNull((Object)run, (String)"run");
        return this.getRow().runBeginsAt(run);
    }

    public int getX() {
        return this.getRow().x;
    }

    public int getY() {
        return this.getRow().y;
    }

    public Node getNode() {
        return this.getParaContainer();
    }

    public Paragraph getParagraph() {
        if (this.noContent()) {
            return null;
        }
        Node parent = this.getFirstRunOfRow().getParentNode();
        return parent instanceof Paragraph ? (Paragraph)parent : null;
    }

    protected Node getParaContainer() {
        if (this.noContent()) {
            return null;
        }
        Paragraph para = this.getParagraph();
        return para != null ? para.getParentNode() : null;
    }

    public boolean coversPos(int x, int y) {
        if (this.noContent()) {
            return false;
        }
        Row r = this.getRow();
        if (r.getRowY() != y) {
            return false;
        }
        if (x < r.getRowX()) {
            return false;
        }
        return x <= r.getRowX() + this.getText().length();
    }

    public Run getRunUnderPos(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("pos may not be negative");
        }
        if (this.noContent()) {
            throw new RuntimeException("The iterator is without content");
        }
        return this.rows[this.current].getRunUnderPos(pos);
    }

    public Row getRow() {
        if (this.noContent()) {
            throw new RuntimeException("Iterator is without content");
        }
        if (this.current < 0 || this.current >= this.rows.length) {
            return null;
        }
        return this.rows[this.current];
    }

    protected Run getFirstRunOfRow() {
        if (this.noContent()) {
            return null;
        }
        return this.rows[this.current].getFirstRun();
    }

    public static interface Matching {
        public boolean isRowMatching(Node var1, Paragraph var2, Row var3);
    }
}

