/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.reader;

import java.net.URL;
import java.util.EnumSet;
import java.util.LinkedList;
import org.luwrain.controls.AbstractRegionPoint;
import org.luwrain.controls.ClipboardTranslator;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.RegionPoint;
import org.luwrain.controls.reader.DefaultAnnouncement;
import org.luwrain.controls.reader.DefaultTransition;
import org.luwrain.controls.reader.Jump;
import org.luwrain.controls.reader.SentenceIterator;
import org.luwrain.controls.reader.Strings;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.ListenableArea;
import org.luwrain.core.NullCheck;
import org.luwrain.core.UniRefInfo;
import org.luwrain.core.UniRefUtils;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.MoveHotPointEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.UniRefAreaQuery;
import org.luwrain.core.queries.UniRefHotPointQuery;
import org.luwrain.core.queries.UrlAreaQuery;
import org.luwrain.reader.Document;
import org.luwrain.reader.ExtraInfo;
import org.luwrain.reader.Run;
import org.luwrain.reader.view.Iterator;
import org.luwrain.reader.view.Layout;
import org.luwrain.reader.view.TextExtractorWhole;
import org.luwrain.reader.view.View;
import org.luwrain.util.WordIterator;

public class ReaderArea
implements Area,
ListenableArea,
ClipboardTranslator.Provider {
    protected final ControlContext context;
    protected final RegionPoint regionPoint = new RegionPoint();
    protected final ClipboardTranslator clipboardTranslator = new ClipboardTranslator((ClipboardTranslator.Provider)this, (AbstractRegionPoint)this.regionPoint, EnumSet.noneOf(ClipboardTranslator.Flags.class));
    protected final String name;
    protected final Announcement announcement;
    protected final Transition transition;
    protected ClickHandler clickHandler = null;
    protected Document document = null;
    protected View view = null;
    protected Layout layout = null;
    protected Iterator iterator = null;
    protected int hotPointX = 0;

    public ReaderArea(Params params) {
        NullCheck.notNull((Object)params, (String)"params");
        NullCheck.notNull((Object)params.context, (String)"params.context");
        NullCheck.notNull((Object)params.transition, (String)"params.transition");
        NullCheck.notNull((Object)params.name, (String)"params.name");
        this.context = params.context;
        this.announcement = params.announcement != null ? params.announcement : new DefaultAnnouncement(params.context, (Strings)params.context.getI18n().getStrings("luwrain.controls.reader"));
        this.transition = params.transition;
        this.clickHandler = params.clickHandler;
        if (params.doc != null) {
            if (params.width < 0) {
                throw new IllegalArgumentException("width (" + params.width + ") may not be negative");
            }
            this.setDocument(params.doc, params.width);
        }
        this.name = params.name;
    }

    public ReaderArea(ControlContext context, Announcement announcement, Document document, int width) {
        NullCheck.notNull((Object)context, (String)"context");
        NullCheck.notNull((Object)announcement, (String)"announcement");
        this.context = context;
        this.announcement = announcement;
        if (document != null) {
            if (width < 0) {
                throw new IllegalArgumentException("width (" + width + ") may not be negative");
            }
            this.setDocument(document, width);
        }
        this.transition = new DefaultTransition();
        this.name = "";
    }

    public ReaderArea(ControlContext context, Announcement announcement) {
        this(context, announcement, null, 0);
    }

    public void setDocument(Document document, int width) {
        NullCheck.notNull((Object)document, (String)"document");
        if (width < 0) {
            throw new IllegalArgumentException("width (" + width + ") may not be negative");
        }
        this.document = document;
        this.view = new View(document, width);
        this.layout = this.view.createLayout();
        int defaultIndex = -1;
        if (!document.getProperty("defaultiteratorindex").isEmpty()) {
            try {
                defaultIndex = Integer.parseInt(document.getProperty("defaultiteratorindex"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (defaultIndex >= 0) {
            try {
                this.iterator = this.view.getIterator(defaultIndex);
            }
            catch (IllegalArgumentException e) {
                this.iterator = this.view.getIterator();
            }
        } else {
            this.iterator = this.view.getIterator();
        }
        this.hotPointX = 0;
        this.context.onAreaNewContent((Area)this);
        this.context.onAreaNewHotPoint((Area)this);
    }

    public boolean hasDocument() {
        return this.document != null && this.iterator != null;
    }

    public boolean isEmpty() {
        return !this.hasDocument() || this.iterator.noContent();
    }

    public Document getDocument() {
        return this.document;
    }

    public String getDocTitle() {
        if (!this.hasDocument()) {
            return "";
        }
        String res = this.getDocument().getTitle();
        return res != null ? res : "";
    }

    public String getDocUrl() {
        if (!this.hasDocument()) {
            return "";
        }
        URL url = this.document.getUrl();
        return url != null ? url.toString() : "";
    }

    public String getDocUniRef() {
        String addr = this.getDocUrl();
        if (addr.isEmpty()) {
            return "";
        }
        return UniRefInfo.makeValue((String)"url", (String)addr);
    }

    public Run getCurrentRun() {
        if (this.isEmpty()) {
            return null;
        }
        return this.iterator.getRunUnderPos(this.hotPointX);
    }

    public boolean findRun(Run run) {
        NullCheck.notNull((Object)run, (String)"run");
        if (this.isEmpty()) {
            return false;
        }
        Iterator newIt = this.view.getIterator();
        while (newIt.canMoveNext() && !newIt.hasRunOnRow(run)) {
            newIt.moveNext();
        }
        if (!newIt.hasRunOnRow(run)) {
            return false;
        }
        int pos = newIt.runBeginsAt(run);
        if (pos < 0) {
            return false;
        }
        this.iterator = newIt;
        this.hotPointX = pos;
        this.context.onAreaNewHotPoint((Area)this);
        return true;
    }

    public int getCurrentRowIndex() {
        return !this.isEmpty() ? this.iterator.getIndex() : -1;
    }

    public boolean setCurrentRowIndex(int index) {
        Iterator newIt;
        if (this.isEmpty()) {
            return false;
        }
        try {
            newIt = this.view.getIterator(index);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        this.iterator = newIt;
        this.hotPointX = 0;
        this.context.onAreaNewHotPoint((Area)this);
        return true;
    }

    public String[] getHtmlIds() {
        if (this.isEmpty()) {
            return new String[0];
        }
        LinkedList<String> res = new LinkedList<String>();
        Run run = this.iterator.getRunUnderPos(this.hotPointX);
        if (run == null) {
            return new String[0];
        }
        ExtraInfo info = run.extraInfo();
        while (info != null) {
            String value;
            if (info.attrs.containsKey("id") && !(value = info.attrs.get("id")).isEmpty()) {
                res.add(value);
            }
            info = info.parent;
        }
        return res.toArray(new String[res.size()]);
    }

    public boolean rebuildView(int width) {
        if (this.isEmpty()) {
            return false;
        }
        Run currentRun = this.getCurrentRun();
        this.view = new View(this.document, width);
        this.layout = this.view.createLayout();
        if (currentRun != null) {
            this.findRun(currentRun);
        }
        this.hotPointX = Math.min(this.hotPointX, this.iterator.getText().length());
        this.context.onAreaNewContent((Area)this);
        this.context.onAreaNewHotPoint((Area)this);
        return true;
    }

    public int getLineCount() {
        return !this.isEmpty() ? this.layout.getLineCount() + 1 : 1;
    }

    public String getLine(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index (" + index + ") may not be negative");
        }
        if (this.isEmpty()) {
            return index == 0 ? this.noContentStr() : "";
        }
        return index < this.layout.getLineCount() ? this.layout.getLine(index) : "";
    }

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (!event.isSpecial() && !event.isModified()) {
            switch (InputEvent.getKeyboardLayout().getAsciiOfButton(event.getChar())) {
                case ' ': {
                    return this.onFindNextHref();
                }
                case '[': {
                    return this.onTransition(event, Transition.Type.PREV_PARAGRAPH, false, Hint.NO_LINES_ABOVE);
                }
                case ']': {
                    return this.onTransition(event, Transition.Type.NEXT_PARAGRAPH, false, Hint.NO_LINES_BELOW);
                }
                case '.': {
                    return this.onNextSentence(event);
                }
            }
        }
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case ENTER: {
                    return this.onClick();
                }
                case ARROW_DOWN: {
                    return this.onTransition(event, Transition.Type.NEXT, false, Hint.NO_LINES_BELOW);
                }
                case ARROW_UP: {
                    return this.onTransition(event, Transition.Type.PREV, false, Hint.NO_LINES_ABOVE);
                }
                case ALTERNATIVE_ARROW_DOWN: {
                    return this.onTransition(event, Transition.Type.STRICT_NEXT, false, Hint.NO_LINES_BELOW);
                }
                case ALTERNATIVE_ARROW_UP: {
                    return this.onTransition(event, Transition.Type.STRICT_PREV, false, Hint.NO_LINES_BELOW);
                }
                case ARROW_LEFT: {
                    return this.onMoveLeft(event);
                }
                case ARROW_RIGHT: {
                    return this.onMoveRight(event);
                }
                case ALTERNATIVE_ARROW_LEFT: {
                    return this.onAltLeft(event);
                }
                case ALTERNATIVE_ARROW_RIGHT: {
                    return this.onAltRight(event);
                }
                case HOME: {
                    return this.onHome(event);
                }
                case END: {
                    return this.onEnd(event);
                }
                case ALTERNATIVE_HOME: {
                    return this.onAltHome(event);
                }
                case ALTERNATIVE_END: {
                    return this.onAltEnd(event);
                }
                case PAGE_UP: {
                    return this.onTransition(event, Transition.Type.PREV_SECTION, false, Hint.NO_LINES_ABOVE);
                }
                case PAGE_DOWN: {
                    return this.onTransition(event, Transition.Type.NEXT_SECTION, false, Hint.NO_LINES_BELOW);
                }
                case ALTERNATIVE_PAGE_UP: {
                    return this.onTransition(event, Transition.Type.PREV_SECTION_SAME_LEVEL, false, Hint.NO_LINES_ABOVE);
                }
                case ALTERNATIVE_PAGE_DOWN: {
                    return this.onTransition(event, Transition.Type.NEXT_SECTION_SAME_LEVEL, false, Hint.NO_LINES_BELOW);
                }
            }
        }
        return false;
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return false;
        }
        switch (event.getCode()) {
            case MOVE_HOT_POINT: {
                if (event instanceof MoveHotPointEvent) {
                    return this.onMoveHotPoint((MoveHotPointEvent)event);
                }
                return false;
            }
        }
        return this.clipboardTranslator.onSystemEvent(event, this.getHotPointX(), this.getHotPointY());
    }

    public Action[] getAreaActions() {
        return new Action[0];
    }

    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        switch (query.getQueryCode()) {
            case 1: {
                String title = this.getDocTitle();
                String uniRef = this.getDocUniRef();
                if (uniRef.isEmpty()) {
                    return false;
                }
                if (title.isEmpty()) {
                    ((UniRefAreaQuery)query).answer(uniRef);
                } else {
                    ((UniRefAreaQuery)query).answer(UniRefUtils.makeAlias((String)title, (String)uniRef));
                }
                return true;
            }
            case 3: {
                String url = this.getDocUrl();
                if (url.isEmpty()) {
                    return false;
                }
                ((UrlAreaQuery)query).answer(url);
                return true;
            }
            case 2: {
                Run run = this.getCurrentRun();
                if (this.isEmpty() || run == null) {
                    return false;
                }
                String res = this.getCurrentRun().href();
                if (res == null || res.isEmpty()) {
                    return false;
                }
                ((UniRefHotPointQuery)query).answer("url:" + res);
                return true;
            }
        }
        return false;
    }

    public int getHotPointX() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.iterator.getX() + this.hotPointX;
    }

    public int getHotPointY() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.iterator.getY();
    }

    public String getAreaName() {
        if (this.name.isEmpty()) {
            return this.getDocTitle();
        }
        return this.name;
    }

    public boolean onClipboardCopyAll() {
        if (this.isEmpty()) {
            return false;
        }
        TextExtractorWhole extractor = new TextExtractorWhole(this.context.getScreenWidth());
        extractor.onNode(this.document.getRoot());
        this.context.getClipboard().set((Object[])extractor.getLines());
        return true;
    }

    public boolean onClipboardCopy(int fromX, int fromY, int toX, int toY, boolean withDeleting) {
        if (this.isEmpty() || withDeleting) {
            return false;
        }
        Run run1 = null;
        Run run2 = null;
        Iterator it = new Iterator(this.view);
        if (it.noContent()) {
            return false;
        }
        do {
            if (it.coversPos(fromX, fromY) && (run1 = it.getRunUnderPos(fromX - it.getX())) == null) {
                throw new RuntimeException("The iterator is unable to provide a run under the covered point");
            }
            if (!it.coversPos(toX, toY)) continue;
            run2 = it.getRunUnderPos(toX - it.getX());
            if (run1 != null) continue;
            throw new RuntimeException("The iterator is unable to provide a run under the covered point");
        } while (it.moveNext());
        if (run1 == null || run2 == null) {
            return false;
        }
        this.context.getClipboard().set((Object[])new String[]{run1.text(), run2.text()});
        return true;
    }

    public boolean onDeleteRegion(int fromX, int fromY, int toX, int toY) {
        return false;
    }

    public ListenableArea.ListeningInfo onListeningStart() {
        Jump jump = Jump.nextSentence(this.iterator, this.hotPointX);
        if (jump.isEmpty()) {
            return new ListenableArea.ListeningInfo();
        }
        return new ListeningInfo(this.textUntil(jump.it, jump.pos), jump.it, jump.pos);
    }

    public void onListeningFinish(ListenableArea.ListeningInfo listeningInfo) {
        NullCheck.notNull((Object)listeningInfo, (String)"listeningInfo");
        if (!(listeningInfo instanceof ListeningInfo)) {
            return;
        }
        ListeningInfo info = (ListeningInfo)listeningInfo;
        this.iterator = info.it;
        this.hotPointX = info.pos;
        this.context.onAreaNewHotPoint((Area)this);
    }

    protected boolean onMoveHotPoint(MoveHotPointEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.isEmpty()) {
            return false;
        }
        Iterator it2 = this.view.getIterator();
        int x = event.getNewHotPointX();
        int y = event.getNewHotPointY();
        if (x < 0 || y < 0) {
            return false;
        }
        Iterator nearest = null;
        while (it2.canMoveNext() && !it2.coversPos(x, y)) {
            if (it2.getY() == y) {
                nearest = it2.clone();
            }
            it2.moveNext();
        }
        if (it2.coversPos(x, y) && x >= it2.getX()) {
            this.iterator = it2;
            this.hotPointX = x - this.iterator.getX();
            this.context.onAreaNewHotPoint((Area)this);
            return true;
        }
        if (event.precisely()) {
            return false;
        }
        if (nearest != null) {
            this.iterator = nearest;
            this.hotPointX = 0;
            return true;
        }
        return false;
    }

    protected boolean onClick() {
        if (this.clickHandler == null) {
            return false;
        }
        Run run = this.getCurrentRun();
        if (run == null) {
            return false;
        }
        return this.clickHandler.onReaderClick(this, run);
    }

    protected boolean onTransition(InputEvent event, Transition.Type type, boolean briefAnnouncement, Hint hintFailed) {
        NullCheck.notNull((Object)event, (String)"event");
        NullCheck.notNull((Object)((Object)type), (String)"type");
        NullCheck.notNull((Object)hintFailed, (String)"hintFailed");
        if (this.noContentCheck()) {
            return true;
        }
        if (this.transition.transition(type, this.iterator)) {
            this.onNewRow(briefAnnouncement);
        } else {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)hintFailed));
        }
        return true;
    }

    protected boolean onAltEnd(InputEvent event) {
        if (this.noContentCheck()) {
            return true;
        }
        this.iterator.moveEnd();
        this.onNewRow(false);
        return true;
    }

    protected boolean onAltHome(InputEvent event) {
        if (this.noContentCheck()) {
            return true;
        }
        this.iterator.moveBeginning();
        this.onNewRow(false);
        return true;
    }

    protected boolean onNextSentence(InputEvent event) {
        if (this.noContentCheck()) {
            return true;
        }
        SentenceIterator sentIt = new SentenceIterator(this.iterator, this.hotPointX);
        StringBuilder b = new StringBuilder();
        if (!sentIt.forward(b, " ")) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.NO_LINES_BELOW));
            return true;
        }
        if (sentIt.atRowEnd() && !sentIt.forward(b, " ")) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.NO_LINES_BELOW));
            return true;
        }
        this.iterator = sentIt.getIterator();
        this.hotPointX = sentIt.getPos();
        b = new StringBuilder();
        sentIt.forward(b, " ");
        String text = new String(b).trim();
        this.context.onAreaNewHotPoint((Area)this);
        if (!text.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.text((String)text));
        } else {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.EMPTY_LINE));
        }
        return true;
    }

    protected boolean onMoveLeft(InputEvent event) {
        if (this.noContentCheck()) {
            return true;
        }
        String text = this.iterator.getText();
        this.hotPointX = Math.min(this.hotPointX, text.length());
        if (this.hotPointX > 0) {
            --this.hotPointX;
            this.context.setEventResponse(DefaultEventResponse.letter((char)text.charAt(this.hotPointX)));
            this.context.onAreaNewHotPoint((Area)this);
            return true;
        }
        if (!this.iterator.canMovePrev()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.BEGIN_OF_TEXT));
            return true;
        }
        this.iterator.movePrev();
        String prevRowText = this.iterator.getText();
        this.hotPointX = prevRowText.length();
        this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.LINE_BOUND));
        return true;
    }

    protected boolean onMoveRight(InputEvent event) {
        if (this.noContentCheck()) {
            return true;
        }
        String text = this.iterator.getText();
        if (this.hotPointX < text.length()) {
            ++this.hotPointX;
            if (this.hotPointX < text.length()) {
                this.context.setEventResponse(DefaultEventResponse.letter((char)text.charAt(this.hotPointX)));
            } else {
                this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.LINE_BOUND));
            }
            this.context.onAreaNewHotPoint((Area)this);
            return true;
        }
        if (!this.iterator.canMoveNext()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.END_OF_TEXT));
            return true;
        }
        this.iterator.moveNext();
        String nextRowText = this.iterator.getText();
        this.hotPointX = 0;
        if (nextRowText.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.LINE_BOUND));
        } else {
            this.context.setEventResponse(DefaultEventResponse.letter((char)nextRowText.charAt(0)));
        }
        this.context.onAreaNewHotPoint((Area)this);
        return true;
    }

    protected boolean onAltLeft(InputEvent event) {
        if (this.noContentCheck()) {
            return true;
        }
        String text = this.iterator.getText();
        WordIterator it = new WordIterator(text, this.hotPointX);
        if (!it.stepBackward()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.BEGIN_OF_LINE));
            return true;
        }
        this.hotPointX = it.pos();
        this.context.setEventResponse(DefaultEventResponse.text((String)it.announce()));
        this.context.onAreaNewHotPoint((Area)this);
        return true;
    }

    protected boolean onAltRight(InputEvent event) {
        if (this.noContentCheck()) {
            return true;
        }
        String text = this.iterator.getText();
        WordIterator it = new WordIterator(text, this.hotPointX);
        if (!it.stepForward()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.END_OF_LINE));
            return true;
        }
        this.hotPointX = it.pos();
        if (it.announce().length() > 0) {
            this.context.setEventResponse(DefaultEventResponse.text((String)it.announce()));
        } else {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.END_OF_LINE));
        }
        this.context.onAreaNewHotPoint((Area)this);
        return true;
    }

    protected boolean onHome(InputEvent event) {
        if (this.noContentCheck()) {
            return true;
        }
        String text = this.iterator.getText();
        this.hotPointX = 0;
        if (!text.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.letter((char)text.charAt(0)));
        } else {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.EMPTY_LINE));
        }
        this.context.onAreaNewHotPoint((Area)this);
        return true;
    }

    protected boolean onEnd(InputEvent event) {
        if (this.noContentCheck()) {
            return true;
        }
        String text = this.iterator.getText();
        this.hotPointX = text.length();
        this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.LINE_BOUND));
        this.context.onAreaNewHotPoint((Area)this);
        return true;
    }

    protected boolean onFindNextHref() {
        int k;
        Run[] runs;
        if (this.noContentCheck()) {
            return true;
        }
        Run currentRun = this.iterator.getRunUnderPos(this.hotPointX);
        if (currentRun != null) {
            runs = this.iterator.getRuns();
            boolean skipping = true;
            for (Run r : runs) {
                if (r == currentRun) {
                    skipping = false;
                    continue;
                }
                if (skipping || r.href() == null || r.href().trim().isEmpty()) continue;
                this.hotPointX = this.iterator.runBeginsAt(r);
                this.context.say(r.text());
                this.context.onAreaNewHotPoint((Area)this);
                return true;
            }
        }
        if (this.iterator.getIndex() + 1 >= this.iterator.getCount()) {
            return false;
        }
        if (!this.iterator.searchForward((node, para, row) -> {
            Run[] runs;
            for (Run r : runs = row.getRuns()) {
                if (r.href() == null || r.href().trim().isEmpty()) continue;
                return true;
            }
            return false;
        }, this.iterator.getIndex() + 1)) {
            return false;
        }
        runs = this.iterator.getRuns();
        for (k = 0; k < runs.length && (runs[k].href() == null || runs[k].href().trim().isEmpty()); ++k) {
        }
        if (k >= runs.length) {
            return false;
        }
        this.hotPointX = this.iterator.runBeginsAt(runs[k]);
        this.context.say(runs[k].text());
        this.context.onAreaNewHotPoint((Area)this);
        return true;
    }

    protected void onNewRow(boolean briefAnnouncement) {
        this.hotPointX = 0;
        this.context.onAreaNewHotPoint((Area)this);
        this.announcement.announce(this.iterator, briefAnnouncement);
    }

    protected String noContentStr() {
        return this.context.getStaticStr("DocumentNoContent");
    }

    private boolean noContentCheck() {
        if (this.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.NO_CONTENT, (String)this.noContentStr()));
            return true;
        }
        return false;
    }

    protected static int findEndOfSentence(String text, int startFrom) {
        NullCheck.notNull((Object)text, (String)"text");
        for (int i = startFrom; i < text.length(); ++i) {
            if (!ReaderArea.charOfSentenceEnd(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    protected static boolean charOfSentenceEnd(char ch) {
        switch (ch) {
            case '!': 
            case '.': 
            case '?': {
                return true;
            }
        }
        return false;
    }

    protected String textUntil(Iterator itTo, int posTo) {
        NullCheck.notNull((Object)itTo, (String)"itTo");
        Iterator tmpIt = this.iterator.clone();
        if (tmpIt.equals(itTo)) {
            return tmpIt.getText().substring(this.hotPointX, posTo);
        }
        StringBuilder b = new StringBuilder();
        b.append(tmpIt.getText().substring(this.hotPointX));
        while (tmpIt.moveNext() && !tmpIt.equals(itTo)) {
            b.append(" " + tmpIt.getText());
        }
        if (tmpIt.equals(itTo)) {
            b.append(" " + tmpIt.getText().substring(0, posTo));
        }
        return new String(b);
    }

    public static interface ClickHandler {
        public boolean onReaderClick(ReaderArea var1, Run var2);
    }

    public static final class Params {
        public ControlContext context = null;
        public String name = "";
        public ClickHandler clickHandler = null;
        public Announcement announcement = null;
        public Transition transition = new DefaultTransition();
        public Document doc = null;
        public int width = 100;
    }

    public static interface Transition {
        public boolean transition(Type var1, Iterator var2);

        public static enum Type {
            NEXT,
            PREV,
            STRICT_NEXT,
            STRICT_PREV,
            NEXT_SECTION,
            PREV_SECTION,
            NEXT_SECTION_SAME_LEVEL,
            PREV_SECTION_SAME_LEVEL,
            NEXT_PARAGRAPH,
            PREV_PARAGRAPH;

        }
    }

    public static interface Announcement {
        public void announce(Iterator var1, boolean var2);
    }

    protected static class ListeningInfo
    extends ListenableArea.ListeningInfo {
        final Iterator it;
        final int pos;

        ListeningInfo(String text, Iterator it, int pos) {
            super(text);
            NullCheck.notNull((Object)it, (String)"it");
            this.it = it;
            this.pos = pos;
        }
    }

    public static enum State {
        LOADING,
        READY;

    }
}

