/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader.books;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Parser;
import org.luwrain.app.reader.books.AudioFragment;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;

final class Smil {
    private static final String LOG_COMPONENT = "smil";
    private static final Pattern TIME_PATTERN = Pattern.compile("^npt=(?<sec>\\d+.\\d+)s$");

    Smil() {
    }

    public static Entry fromUrl(URL url) {
        Document doc;
        NullCheck.notNull((Object)url, (String)"url");
        try {
            if (!url.getProtocol().equals("file")) {
                Connection con = Jsoup.connect((String)url.toString());
                con.userAgent("Mozilla/5.0");
                con.timeout(30000);
                doc = con.get();
            } else {
                doc = Jsoup.parse((InputStream)url.openStream(), (String)"utf-8", (String)"", (Parser)Parser.xmlParser());
            }
        }
        catch (Exception e) {
            Log.error((String)LOG_COMPONENT, (String)("unable to fetch SMIL from URL " + url.toString() + ":" + e.getClass().getName() + ":" + e.getMessage()));
            return null;
        }
        return new Entry(Entry.Type.FILE, Smil.onNode((Node)doc.body()));
    }

    static Entry fromFile(java.io.File file) {
        Document doc;
        NullCheck.notNull((Object)file, (String)"file");
        try {
            doc = Jsoup.parse((InputStream)new FileInputStream(file), (String)"utf-8", (String)"", (Parser)Parser.xmlParser());
        }
        catch (Exception e) {
            Log.error((String)LOG_COMPONENT, (String)("unable to parse " + file.getAbsolutePath() + ":" + e.getClass().getName() + ":" + e.getMessage()));
            return null;
        }
        return new Entry(Entry.Type.FILE, Smil.onNode((Node)doc.body()));
    }

    private static Entry[] onNode(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        LinkedList<Entry> res = new LinkedList<Entry>();
        LinkedList runs = new LinkedList();
        List childNodes = node.childNodes();
        block12: for (Node n : childNodes) {
            String name = n.nodeName();
            if (n instanceof TextNode) {
                TextNode textNode = (TextNode)n;
                String text = textNode.text();
                if (text.trim().isEmpty()) continue;
                Log.warning((String)LOG_COMPONENT, (String)("unexpected text content:" + text));
                continue;
            }
            if (!(n instanceof Element)) continue;
            Element el = (Element)n;
            switch (name.trim().toLowerCase()) {
                case "seq": {
                    res.add(new Entry(Entry.Type.SEQ, el.attr("id"), Smil.onNode((Node)el)));
                    continue block12;
                }
                case "par": {
                    res.add(new Entry(Entry.Type.PAR, el.attr("id"), Smil.onNode((Node)el)));
                    continue block12;
                }
                case "audio": {
                    res.add(Smil.onAudio(el));
                    continue block12;
                }
                case "text": {
                    res.add(Smil.onText(el));
                    continue block12;
                }
            }
            Log.warning((String)LOG_COMPONENT, (String)("unknown tag:" + name));
        }
        return res.toArray(new Entry[res.size()]);
    }

    private static Entry onAudio(Element el) {
        NullCheck.notNull((Object)el, (String)"el");
        String id = el.attr("id");
        String src = el.attr("src");
        String beginValue = el.attr("clip-begin");
        String endValue = el.attr("clip-end");
        long beginPos = -1L;
        long endPos = -1L;
        if (beginValue != null) {
            beginPos = Smil.parseTime(beginValue);
        }
        if (endValue != null) {
            endPos = Smil.parseTime(endValue);
        }
        return new Entry(id, src, new AudioFragment(src, beginPos, endPos));
    }

    private static Entry onText(Element el) {
        NullCheck.notNull((Object)el, (String)"el");
        String id = el.attr("id");
        String src = el.attr("src");
        return new Entry(Entry.Type.TEXT, id, src);
    }

    private static long parseTime(String value) {
        Matcher m = TIME_PATTERN.matcher(value);
        if (m.matches()) {
            try {
                float f = Float.parseFloat(m.group("sec"));
                return new Float(f *= 1000.0f).longValue();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return -1L;
    }

    static class Entry {
        final Type type;
        final String id;
        final Entry[] entries;
        private String src = null;
        private final AudioFragment audioInfo;

        Entry(Type type) {
            NullCheck.notNull((Object)((Object)type), (String)"type");
            this.type = type;
            this.id = "";
            this.audioInfo = null;
            this.entries = new Entry[0];
        }

        Entry(Type type, Entry[] entries) {
            NullCheck.notNull((Object)((Object)type), (String)"type");
            NullCheck.notNullItems((Object[])entries, (String)"entries");
            this.type = type;
            this.id = "";
            this.audioInfo = null;
            this.entries = entries;
        }

        Entry(Type type, String id, Entry[] entries) {
            NullCheck.notNull((Object)((Object)type), (String)"type");
            NullCheck.notNull((Object)id, (String)"id");
            NullCheck.notNullItems((Object[])entries, (String)"entries");
            this.type = type;
            this.id = id;
            this.audioInfo = null;
            this.entries = entries;
        }

        Entry(Type type, String id, String src) {
            NullCheck.notNull((Object)((Object)type), (String)"type");
            NullCheck.notNull((Object)id, (String)"id");
            NullCheck.notNull((Object)src, (String)"src");
            this.type = type;
            this.id = id;
            this.src = src;
            this.audioInfo = null;
            this.entries = new Entry[0];
        }

        Entry(String id, String src, AudioFragment audioInfo) {
            NullCheck.notNull((Object)id, (String)"id");
            NullCheck.notNull((Object)src, (String)"src");
            NullCheck.notNull((Object)audioInfo, (String)"audioInfo");
            this.type = Type.AUDIO;
            this.id = id;
            this.src = src;
            this.audioInfo = audioInfo;
            this.entries = new Entry[0];
        }

        void saveTextSrc(List<String> res) {
            if (this.type == Type.TEXT && this.src != null && !this.src.isEmpty()) {
                res.add(this.src);
            }
            if (this.entries != null) {
                for (Entry e : this.entries) {
                    e.saveTextSrc(res);
                }
            }
        }

        void allSrcToUrls(URL base) throws MalformedURLException {
            NullCheck.notNull((Object)base, (String)"base");
            if (this.src != null && !this.src.isEmpty()) {
                this.src = new URL(base, this.src).toString();
            }
            if (this.entries != null) {
                for (Entry e : this.entries) {
                    e.allSrcToUrls(base);
                }
            }
        }

        Entry findById(String id) {
            NullCheck.notNull((Object)id, (String)"id");
            if (this.id != null && this.id.equals(id)) {
                return this;
            }
            if (this.entries == null) {
                return null;
            }
            for (Entry e : this.entries) {
                Entry res = e.findById(id);
                if (res == null) continue;
                return res;
            }
            return null;
        }

        AudioFragment getAudioFragment() {
            return this.audioInfo;
        }

        String src() {
            return this.src;
        }

        public static enum Type {
            SEQ,
            PAR,
            AUDIO,
            TEXT,
            FILE;

        }
    }

    static final class File
    extends Entry {
        File() {
            super(Entry.Type.FILE);
        }
    }
}

