/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.reader.App;
import org.luwrain.app.reader.AudioPlaying;
import org.luwrain.app.reader.Notes;
import org.luwrain.app.reader.books.Book;
import org.luwrain.controls.reader.ReaderArea;
import org.luwrain.core.NullCheck;
import org.luwrain.io.api.books.v1.Note;
import org.luwrain.reader.Document;

final class BookContainer {
    private final App app;
    private final Book book;
    final String bookId;
    final Notes notes;
    private final LinkedList<HistoryItem> history = new LinkedList();
    private Book.Section[] sections = new Book.Section[0];
    private Document doc = null;

    BookContainer(App app, Book book, String bookId) {
        NullCheck.notNull((Object)((Object)app), (String)"app");
        NullCheck.notNull((Object)book, (String)"book");
        NullCheck.notEmpty((Object)bookId, (String)"bookId");
        this.app = app;
        this.book = book;
        this.bookId = bookId;
        this.doc = this.book.getDefaultDocument();
        this.notes = new Notes(app, bookId);
        Note bookmark = this.notes.getBookmark();
        if (bookmark != null && bookmark.getPos() != null && !bookmark.getPos().isEmpty()) {
            this.doc.setProperty("defaultiteratorindex", bookmark.getPos());
        }
        app.setAppName(this.doc.getTitle());
    }

    boolean jump(String href, ReaderArea readerArea, int newRowNum, Runnable onSuccess) {
        NullCheck.notEmpty((Object)href, (String)"href");
        NullCheck.notNull((Object)readerArea, (String)"readerArea");
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        if (this.app.isBusy()) {
            return false;
        }
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            Document doc;
            try {
                doc = this.book.getDocument(href);
            }
            catch (IOException e) {
                this.app.showErrorLayout(e);
                return;
            }
            if (doc == null) {
                return;
            }
            if (doc != this.doc) {
                this.history.add(new HistoryItem(this.doc));
                int currentRowNum = readerArea.getCurrentRowIndex();
                if (currentRowNum >= 0) {
                    this.history.getLast().lastRowIndex = currentRowNum;
                }
            }
            if (newRowNum >= 0) {
                doc.setProperty("defaultiteratorindex", String.valueOf(newRowNum));
            }
            this.app.finishedTask(taskId, () -> {
                this.doc = doc;
                this.app.setAppName(doc.getTitle());
                onSuccess.run();
            });
        });
    }

    boolean onPrevDoc(Runnable onSuccess) {
        if (this.history.isEmpty()) {
            return false;
        }
        HistoryItem item = this.history.pollLast();
        this.doc = item.doc;
        this.doc.setProperty("defaultiteratorindex", String.valueOf(item.lastRowIndex));
        this.app.setAppName(this.doc.getTitle());
        onSuccess.run();
        return true;
    }

    boolean changeCharset(String newCharset) {
        NullCheck.notNull((Object)newCharset, (String)"newCharset");
        return true;
    }

    boolean playAudio(ReaderArea area, String[] ids) {
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNullItems((Object[])ids, (String)"ids");
        AudioPlaying audioPlaying = this.app.getAudioPlaying();
        if (audioPlaying == null) {
            return false;
        }
        return audioPlaying.playAudio(this.book, this.doc, area, ids);
    }

    boolean stopAudio() {
        AudioPlaying audioPlaying = this.app.getAudioPlaying();
        if (audioPlaying == null) {
            return false;
        }
        return audioPlaying.stop();
    }

    Document getDocument() {
        return this.doc;
    }

    Set<Book.Flags> getBookFlags() {
        return this.book.getBookFlags();
    }

    Book.Section[] getSections() {
        Book.Section[] res = this.book.getBookSections();
        return res != null ? res : new Book.Section[]{};
    }

    static final class HistoryItem {
        final Document doc;
        final String url;
        final String contentType;
        final String format;
        final String charset;
        int startingRowIndex;
        int lastRowIndex;

        HistoryItem(Document doc) {
            NullCheck.notNull((Object)doc, (String)"doc");
            this.doc = doc;
            this.url = doc.getProperty("url");
            this.contentType = doc.getProperty("contenttype");
            this.charset = doc.getProperty("charset");
            this.format = doc.getProperty("format");
        }
    }
}

