/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.download;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Registry;
import org.luwrain.io.download.Settings;
import org.luwrain.io.download.Task;

public final class Manager
implements Task.Callback {
    private static final String LOG_COMPONENT = "download";
    private final Luwrain luwrain;
    private final List<EntryImpl> entries = new ArrayList<EntryImpl>();
    private final List<Runnable> changesListeners = new ArrayList<Runnable>();

    public Manager(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
    }

    public synchronized void load() {
        this.entries.clear();
        Object ids = null;
        for (int i = 0; i < (ids).length; ++i) {
        }
        for (EntryImpl e : this.entries) {
            if (!e.isActive()) continue;
            e.task.startAsync();
        }
    }

    public void close() {
        this.changesListeners.clear();
        EntryImpl[] ee = this.entries.toArray(new EntryImpl[this.entries.size()]);
        this.entries.clear();
        for (EntryImpl e : ee) {
            if (!e.isActive()) continue;
            Log.debug((String)LOG_COMPONENT, (String)("stopping download of " + e.task.srcUrl.toString() + " at " + e.bytesFetched + "/" + e.fileSize));
            e.task.stop();
        }
    }

    public synchronized void addDownload(URL srcUrl, File destFile) throws IOException {
        NullCheck.notNull((Object)srcUrl, (String)"srcUrl");
        NullCheck.notNull((Object)destFile, (String)"destFile");
        Log.debug((String)LOG_COMPONENT, (String)("new download: " + srcUrl.toString() + " -> " + destFile.getAbsolutePath()));
        boolean id = false;
        Object entry = null;
        this.entries.add((EntryImpl)entry);
        ((EntryImpl)entry).task.startAsync();
        this.notifyChangesListeners();
    }

    public synchronized Entry[] getAllEntries() {
        return this.entries.toArray(new Entry[this.entries.size()]);
    }

    public synchronized void addChangesListener(Runnable runnable) {
        NullCheck.notNull((Object)runnable, (String)"runnable");
        for (Runnable r : this.changesListeners) {
            if (r != runnable) continue;
            return;
        }
        this.changesListeners.add(runnable);
    }

    public synchronized void removeChangesListener(Runnable runnable) {
        NullCheck.notNull((Object)runnable, (String)"runnable");
        for (int i = 0; i < this.changesListeners.size(); ++i) {
            if (this.changesListeners.get(i) != runnable) continue;
            this.changesListeners.remove(i);
            return;
        }
    }

    private void notifyChangesListeners() {
        for (Runnable r : this.changesListeners) {
            r.run();
        }
    }

    @Override
    public synchronized void setFileSize(Task task, long size) {
        NullCheck.notNull((Object)task, (String)"task");
        for (EntryImpl e : this.entries) {
            if (e.task != task) continue;
            e.fileSize = size >= 0L ? size : 0L;
            this.notifyChangesListeners();
            return;
        }
    }

    @Override
    public synchronized void onProgress(Task task, long bytesFetched) {
        NullCheck.notNull((Object)task, (String)"task");
        for (EntryImpl e : this.entries) {
            if (e.task != task) continue;
            e.bytesFetched = bytesFetched >= 0L ? bytesFetched : 0L;
            int percent = e.getPercent();
            if (percent != e.prevNotificationPercent) {
                this.notifyChangesListeners();
                e.prevNotificationPercent = percent;
            }
            return;
        }
    }

    @Override
    public synchronized void onSuccess(Task task) {
        NullCheck.notNull((Object)task, (String)"task");
        for (EntryImpl e : this.entries) {
            if (e.task != task) continue;
            e.onSuccess();
            this.notifyChangesListeners();
            return;
        }
    }

    @Override
    public synchronized void onFailure(Task task, Throwable throwable) {
        NullCheck.notNull((Object)task, (String)"task");
        NullCheck.notNull((Object)throwable, (String)"throwable");
        for (EntryImpl e : this.entries) {
            if (e.task != task) continue;
            e.onFailure(throwable);
            this.notifyChangesListeners();
            return;
        }
    }

    private static final class EntryImpl
    implements Entry {
        final Task task;
        final Settings.Entry sett;
        long fileSize = 0L;
        long bytesFetched = 0L;
        int prevNotificationPercent = -1;
        private Entry.Status statusCache = null;
        private String errorInfoCache = null;

        EntryImpl(Registry registry, int id, Task.Callback callback) throws IOException {
            NullCheck.notNull((Object)registry, (String)"registry");
            NullCheck.notNull((Object)callback, (String)"callback");
            this.sett = Settings.createEntry(registry, id);
            String url = this.sett.getUrl("");
            String destFile = this.sett.getDestFile("");
            NullCheck.notEmpty((Object)url, (String)"url");
            NullCheck.notEmpty((Object)destFile, (String)"destFile");
            this.task = new Task(callback, new URL(url), new File(destFile));
        }

        boolean isActive() {
            String status = this.sett.getStatus("");
            return !status.equals("completed") && !status.equals("failed");
        }

        void onSuccess() {
            this.sett.setStatus("completed");
        }

        void onFailure(Throwable e) {
            this.sett.setStatus("failed");
            this.sett.setErrorInfo(e.getClass().getName() + ":" + e.getMessage());
        }

        @Override
        public URL getUrl() {
            return this.task.srcUrl;
        }

        @Override
        public Entry.Status getStatus() {
            String statusStr;
            if (this.statusCache != null) {
                return this.statusCache;
            }
            switch (statusStr = this.sett.getStatus("")) {
                case "completed": {
                    this.statusCache = Entry.Status.SUCCESS;
                    return Entry.Status.SUCCESS;
                }
                case "failed": {
                    this.statusCache = Entry.Status.FAILED;
                    return Entry.Status.FAILED;
                }
            }
            return Entry.Status.RUNNING;
        }

        @Override
        public String getErrorInfo() {
            if (this.errorInfoCache != null) {
                return this.errorInfoCache;
            }
            String value = this.sett.getErrorInfo("");
            if (value.isEmpty()) {
                return "";
            }
            this.errorInfoCache = value;
            return value;
        }

        @Override
        public int getPercent() {
            if (this.fileSize <= 0L || this.bytesFetched <= 0L) {
                return 0;
            }
            int res = (int)(this.bytesFetched * 100L / this.fileSize);
            return res <= 100 ? res : 100;
        }
    }

    public static interface Entry {
        public URL getUrl();

        public int getPercent();

        public Status getStatus();

        public String getErrorInfo();

        public static enum Status {
            RUNNING,
            SUCCESS,
            FAILED;

        }
    }
}

