/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.api.mastodon;

import okhttp3.OkHttpClient;
import org.luwrain.io.api.mastodon.MastodonApiService;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Configuration
implements AutoCloseable {
    private OkHttpClient okHttpClient;
    private Retrofit retrofit;
    private MastodonApiService mastodonApiService;

    private OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            this.okHttpClient = new OkHttpClient.Builder().build();
        }
        return this.okHttpClient;
    }

    private Retrofit getRetrofit(String baseUrl) {
        if (this.retrofit == null) {
            this.retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.getOkHttpClient()).build();
        }
        return this.retrofit;
    }

    private MastodonApiService getMastodonApiService(String baseUrl) {
        if (baseUrl == null) {
            baseUrl = "https://mastodon.world/";
        }
        if (this.mastodonApiService == null) {
            this.mastodonApiService = (MastodonApiService)this.getRetrofit(baseUrl).create(MastodonApiService.class);
        }
        return this.mastodonApiService;
    }

    public MastodonApiService getService() {
        return this.getMastodonApiService(null);
    }

    @Override
    public void close() {
        if (this.okHttpClient == null) {
            return;
        }
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
    }
}

