/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.api.lsocial.publication;

import java.util.Objects;
import org.luwrain.io.api.lsocial.Query;
import org.luwrain.io.api.lsocial.publication.GetResponse;
import org.luwrain.io.api.lsocial.publication.Publication;

public final class GetQuery
extends Query<GetQuery, GetResponse> {
    public static final String ADDR = "/v1/publication/get/";
    public static final String ARG_PUBL = "publ";
    public static final String ARG_MODE = "mode";
    public static final int MODE_HEADER = 0;
    public static final int MODE_PREVIEW = 500;
    public static final int MODE_FULL = 1000;

    public GetQuery(String endpoint) {
        super(Query.Type.GET, endpoint, ADDR, GetResponse.class);
    }

    public GetQuery publ(String value) {
        this.args.put(ARG_PUBL, Objects.requireNonNull(value, "value can't be null"));
        return this;
    }

    public GetQuery publ(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value can't be negative");
        }
        this.args.put(ARG_PUBL, String.valueOf(value));
        return this;
    }

    public GetQuery publ(Publication publ) {
        Objects.requireNonNull(publ, "publ can't be null");
        return this.publ(publ.getId());
    }

    public GetQuery mode(int mode) {
        if (mode < 1) {
            throw new IllegalArgumentException("mode can't be negative");
        }
        this.args.put(ARG_MODE, String.valueOf(mode));
        return this;
    }
}

