/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.luwrain.core.NullCheck;

public final class Sha1 {
    public static String getSha1(InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int len;
        NullCheck.notNull((Object)inputStream, (String)"inputStream");
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        sha1.reset();
        byte[] buf = new byte[2048];
        while ((len = inputStream.read(buf)) > 0) {
            sha1.update(buf, 0, len);
        }
        StringBuilder res = new StringBuilder();
        for (byte b : sha1.digest()) {
            String hex;
            int value = Byte.valueOf(b).intValue();
            if (value < 0) {
                value = 256 + value;
            }
            if ((hex = Integer.toHexString(value)).length() < 2) {
                res.append("0");
            }
            res.append(hex);
        }
        return new String(res);
    }

    public static String getSha1(String str, String charset) {
        NullCheck.notNull((Object)str, (String)"str");
        NullCheck.notEmpty((Object)charset, (String)"charset");
        try {
            ByteArrayInputStream s = new ByteArrayInputStream(str.getBytes(charset));
            return Sha1.getSha1(s);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSha1(byte[] bytes) {
        NullCheck.notNull((Object)bytes, (String)"bytes");
        try {
            ByteArrayInputStream s = new ByteArrayInputStream(bytes);
            return Sha1.getSha1(s);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

