/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.luwrain.core.NullCheck;
import org.luwrain.util.StreamUtils;

public final class FileUtils {
    public static final String UTF_8 = "UTF_8";

    public static String readTextFileAsString(File file) throws IOException {
        NullCheck.notNull((Object)file, (String)"file");
        return FileUtils.readTextFileAsString(file, UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFileAsString(File file, String charset) throws IOException {
        byte[] bytes;
        NullCheck.notNull((Object)file, (String)"file");
        NullCheck.notEmpty((Object)charset, (String)"charset");
        try (FileInputStream is = new FileInputStream(file);){
            bytes = StreamUtils.readAllBytes(is);
        }
        return new String(bytes, charset);
    }

    public static String readTextFileSingleString(File file) throws IOException {
        NullCheck.notNull((Object)file, (String)"file");
        return FileUtils.readTextFileAsString(file, UTF_8);
    }

    public static String readTextFileSingleString(File file, String charset) throws IOException {
        NullCheck.notNull((Object)file, (String)"file");
        NullCheck.notEmpty((Object)charset, (String)"charset");
        return FileUtils.readTextFileAsString(file, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFileSingleString(File file, String text, String charset) throws IOException {
        NullCheck.notNull((Object)file, (String)"file");
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notEmpty((Object)charset, (String)"charset");
        FileOutputStream os = new FileOutputStream(file);
        try {
            StreamUtils.writeAllBytes(os, text.getBytes(charset));
        }
        finally {
            os.flush();
            ((OutputStream)os).close();
        }
    }

    public static String[] readTextFileMultipleStrings(File file, String charset, String lineSeparator) throws IOException {
        NullCheck.notNull((Object)file, (String)"file");
        NullCheck.notEmpty((Object)charset, (String)"charset");
        String text = FileUtils.readTextFileSingleString(file, charset);
        if (text.isEmpty()) {
            return new String[0];
        }
        return text.split(lineSeparator != null ? lineSeparator : System.getProperty("line.separator"), -1);
    }

    public static void writeTextFileMultipleStrings(File file, String[] text, String charset, String lineSeparator) throws IOException {
        NullCheck.notNull((Object)file, (String)"file");
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notEmpty((Object)charset, (String)"charset");
        StringBuilder b = new StringBuilder();
        if (text.length > 0) {
            b.append(text[0]);
            for (int i = 1; i < text.length; ++i) {
                b.append((lineSeparator != null ? lineSeparator : System.getProperty("line.separator")) + text[i]);
            }
        }
        FileUtils.writeTextFileSingleString(file, new String(b), charset);
    }

    public static String[] universalLineSplitting(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        boolean wasBN = false;
        boolean wasBR = false;
        ArrayList<String> res = new ArrayList<String>();
        StringBuilder b = new StringBuilder();
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    if (wasBR) {
                        wasBN = true;
                        continue block4;
                    }
                    if (wasBN) {
                        wasBN = false;
                        wasBR = false;
                        res.add("");
                        continue block4;
                    }
                    res.add(new String(b));
                    b = new StringBuilder();
                    wasBN = true;
                    continue block4;
                }
                case '\r': {
                    if (wasBN) {
                        wasBR = true;
                        continue block4;
                    }
                    if (wasBR) {
                        wasBN = false;
                        wasBR = false;
                        res.add("");
                        continue block4;
                    }
                    res.add(new String(b));
                    b = new StringBuilder();
                    wasBR = true;
                    continue block4;
                }
                default: {
                    wasBR = false;
                    wasBN = false;
                    b.append("" + c);
                }
            }
        }
        res.add(new String(b));
        return res.toArray(new String[res.size()]);
    }

    public static File ifNotAbsolute(File baseDir, String path) {
        NullCheck.notNull((Object)baseDir, (String)"baseDir");
        NullCheck.notEmpty((Object)path, (String)"path");
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(baseDir, path);
    }

    public static void createSubdirs(File destDir) throws IOException {
        NullCheck.notNull((Object)destDir, (String)"destDir");
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException(destDir.getAbsolutePath() + " exists and isn't a directory");
            }
            return;
        }
        File parent = destDir.getParentFile();
        if (parent != null) {
            FileUtils.createSubdirs(parent);
        }
        destDir.mkdir();
    }
}

