/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.luwrain.core.NullCheck;

public final class Connections {
    public static final String DEFAULT_USER_AGENT = "Mozilla/5.0";
    private static final int MAX_REDIRECT_COUNT = 16;
    private static final int TIMEOUT = 15000;

    public static URLConnection connect(URI uri, long startFrom) throws IOException {
        NullCheck.notNull((Object)uri, (String)"uri");
        URL urlToTry = uri.toURL();
        for (int i = 0; i < 16; ++i) {
            String decodedLocation;
            URLConnection con = urlToTry.openConnection();
            if (!(con instanceof HttpURLConnection)) {
                con.connect();
                return con;
            }
            HttpURLConnection httpCon = (HttpURLConnection)con;
            httpCon.setRequestProperty("User-Agent", DEFAULT_USER_AGENT);
            httpCon.setConnectTimeout(15000);
            httpCon.setReadTimeout(15000);
            if (startFrom > 0L) {
                httpCon.setRequestProperty("Range", "bytes=" + startFrom + "-");
            }
            httpCon.setInstanceFollowRedirects(false);
            httpCon.connect();
            if (httpCon.getResponseCode() == 301 || httpCon.getResponseCode() == 302) {
                String location = httpCon.getHeaderField("location");
                if (location == null || location.isEmpty()) {
                    throw new IOException("The response has the redirect code but the location is empty (" + urlToTry.toString() + ")");
                }
                decodedLocation = null;
                try {
                    decodedLocation = new String(location.getBytes("ISO8859-1"), "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (decodedLocation == null) {
                    decodedLocation = location;
                }
            } else {
                if (startFrom == 0L && httpCon.getResponseCode() != 200 || startFrom > 0L && httpCon.getResponseCode() != 206) {
                    throw new InvalidHttpResponseCodeException(httpCon.getResponseCode(), urlToTry.toString());
                }
                return httpCon;
            }
            urlToTry = new URL(urlToTry, decodedLocation);
        }
        throw new IOException("Too many redirects (16)");
    }

    public static final class InvalidHttpResponseCodeException
    extends IOException {
        private final int code;
        private final String url;

        public InvalidHttpResponseCodeException(int code, String url) {
            super(code + " for " + url);
            this.code = code;
            this.url = url;
        }

        public int getHttpCode() {
            return this.code;
        }

        public String getHttpUrl() {
            return this.url;
        }
    }
}

