/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings;

import java.util.Objects;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;
import org.luwrain.io.json.CommonSettings;

final class UserInterface
extends FormArea
implements SectionArea {
    private static final String HINTS_SOUNDS = "hints-sounds";
    private static final String HINTS_TEXT = "hints-text";
    private final ControlPanel controlPanel;

    UserInterface(ControlPanel controlPanel) {
        super(new DefaultControlContext(controlPanel.getCoreInterface()), controlPanel.getCoreInterface().i18n().getStaticStr("CpUiGeneral"));
        this.controlPanel = Objects.requireNonNull(controlPanel, "controlPanel can't be null");
        this.fillForm();
    }

    private void fillForm() {
        Luwrain luwrain = this.controlPanel.getCoreInterface();
        CommonSettings conf = Objects.requireNonNullElse(luwrain.loadConf(CommonSettings.class), new CommonSettings());
        this.addCheckbox(HINTS_SOUNDS, luwrain.getString("STATIC:CpUiHintsSounds"), conf.isHintsSounds());
        this.addCheckbox(HINTS_TEXT, luwrain.getString("STATIC:CpUiHintsText"), conf.isHintsText());
        this.addEdit("desktop-title", luwrain.i18n().getStaticStr("CpUiDesktopTitle"), Objects.requireNonNullElse(conf.getDesktopTitle(), ""));
        this.addEdit("window-title", luwrain.getString("STATIC:CpUiWindowTitle"), Objects.requireNonNullElse(conf.getWindowTitle(), ""));
        this.addEdit("desktop-escape-command", luwrain.getString("STATIC:CpUiDesktopEscapeCommand"), Objects.requireNonNullElse(conf.getDesktopEscapeCommand(), ""));
    }

    @Override
    public boolean saveSectionData() {
        Luwrain luwrain = this.controlPanel.getCoreInterface();
        luwrain.updateConf(CommonSettings.class, conf -> {
            conf.setHintsSounds(this.getCheckboxState(HINTS_SOUNDS));
            conf.setHintsText(this.getCheckboxState(HINTS_TEXT));
            conf.setDesktopTitle(this.getEnteredText("desktop-title"));
            conf.setWindowTitle(this.getEnteredText("window-title"));
            conf.setDesktopEscapeCommand(this.getEnteredText("desktop-escape-command"));
        });
        return true;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }

    static UserInterface create(ControlPanel controlPanel) {
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        return new UserInterface(controlPanel);
    }
}

