/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.luwrain.core.NullCheck;
import org.luwrain.i18n.I18n;
import org.luwrain.i18n.Lang;
import org.luwrain.script.core.LangObj;

final class LangsObj
implements ProxyObject {
    private final Map<String, LangObj> langs = new HashMap<String, LangObj>();
    private final Set<String> keysSet;
    private final ProxyArray keysArray;

    LangsObj(I18n i18n) {
        NullCheck.notNull((Object)i18n, (String)"i18n");
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, Lang> e : i18n.getAllLangs().entrySet()) {
            keys.add(e.getKey());
            this.langs.put(e.getKey(), new LangObj(e.getValue()));
        }
        this.keysSet = new HashSet<String>(keys);
        this.keysArray = ProxyArray.fromArray((Object[])keys.toArray(new String[keys.size()]));
    }

    public Object getMember(String name) {
        NullCheck.notNull((Object)name, (String)"name");
        return this.langs.get(name);
    }

    public boolean hasMember(String name) {
        return this.keysSet.contains(name);
    }

    public Object getMemberKeys() {
        return this.keysArray;
    }

    public void putMember(String name, Value value) {
        throw new RuntimeException("The langs object doesn't support updating of its variables");
    }
}

