/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.popups;

import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.popups.ListPopupBase;

public class DisksPopup
extends ListPopupBase<Disk> {
    private static final String LOG_COMPONENT = "popups";
    private static final String PROP_FACTORY_CLASS = "luwrain.class.diskspopupfactory";
    protected File result = null;

    public DisksPopup(Luwrain luwrain, String name, Set<Popup.Flags> popupFlags) {
        super(luwrain, DisksPopup.createParams(luwrain, name), popupFlags);
    }

    public File result() {
        return this.result;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() || !event.isModified()) {
            switch (event.getSpecial()) {
                case DELETE: {
                    if (event.withShift() && event.withControl()) {
                        return this.poweroff();
                    }
                    return this.deactivate();
                }
                case ENTER: {
                    if (this.selected() == null) {
                        return false;
                    }
                    this.closing.doOk();
                    return true;
                }
            }
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() == SystemEvent.Type.BROADCAST) {
            switch (event.getCode()) {
                case REFRESH: {
                    if (event.getBroadcastFilterUniRef().startsWith("disksvolumes:")) {
                        this.refresh();
                    }
                    return true;
                }
            }
            return super.onSystemEvent(event);
        }
        return super.onSystemEvent(event);
    }

    protected boolean deactivate() {
        Disk disk = (Disk)this.selected();
        if (disk == null) {
            return false;
        }
        try {
            if (!disk.deactivate(EnumSet.noneOf(Flags.class))) {
                this.luwrain.message("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e", Luwrain.MessageType.ERROR);
            }
        }
        catch (Throwable e) {
            Log.error(LOG_COMPONENT, "unable to deactivate a disk: " + e.getClass().getName() + ": " + e.getMessage());
            this.luwrain.message("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e", Luwrain.MessageType.ERROR);
        }
        return true;
    }

    protected boolean poweroff() {
        Disk disk = (Disk)this.selected();
        if (disk == null) {
            return false;
        }
        try {
            if (disk.isActivated() && !disk.deactivate(EnumSet.noneOf(Flags.class))) {
                this.luwrain.message("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e", Luwrain.MessageType.ERROR);
                return true;
            }
            if (!disk.poweroff(EnumSet.noneOf(Flags.class))) {
                this.luwrain.message("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e", Luwrain.MessageType.ERROR);
            } else {
                this.refresh();
            }
        }
        catch (Throwable e) {
            Log.error(LOG_COMPONENT, "unable to poweroff a disk: " + e.getClass().getName() + ": " + e.getMessage());
            this.luwrain.message("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e", Luwrain.MessageType.ERROR);
        }
        return true;
    }

    @Override
    public boolean onOk() {
        File res;
        Disk disk = (Disk)this.selected();
        if (disk == null) {
            return false;
        }
        try {
            res = disk.activate(EnumSet.noneOf(Flags.class));
        }
        catch (Throwable e) {
            Log.error(LOG_COMPONENT, "unable to activate a disk: " + e.getClass().getName() + ": " + e.getMessage());
            this.luwrain.message("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e", Luwrain.MessageType.ERROR);
            return false;
        }
        if (res == null) {
            this.luwrain.message("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e", Luwrain.MessageType.ERROR);
            return false;
        }
        this.result = res;
        return true;
    }

    private static void announceDisk(Luwrain luwrain, Disk disk, Set<ListArea.Appearance.Flags> flags) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)disk, (String)"disk");
        NullCheck.notNull(flags, (String)"flags");
        String str = disk.toString().replaceAll(",", " ").replaceAll(",", " ").replaceAll("-", " ");
        if (str.equals("/")) {
            luwrain.setEventResponse(DefaultEventResponse.listItem(luwrain.i18n().getStaticStr("DisksPopupItemRoot"), Suggestions.CLICKABLE_LIST_ITEM));
            return;
        }
        if (str.equals("/home")) {
            luwrain.setEventResponse(DefaultEventResponse.listItem(luwrain.i18n().getStaticStr("DisksPopupItemUserHome"), Suggestions.CLICKABLE_LIST_ITEM));
            return;
        }
        luwrain.setEventResponse(DefaultEventResponse.listItem(disk.isActivated() ? Sounds.ATTENTION : Sounds.LIST_ITEM, luwrain.getSpeakableText(str, Luwrain.SpeakableTextType.PROGRAMMING), Suggestions.CLICKABLE_LIST_ITEM));
    }

    private static Disk[] getDisks(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        Factory factory = luwrain.createInstance(Factory.class);
        if (factory == null) {
            Log.error(LOG_COMPONENT, "no disks popup factory");
            return new Disk[0];
        }
        Disks disks = factory.newDisks(luwrain);
        if (disks == null) {
            Log.debug(LOG_COMPONENT, "the disks factory object gives a null pointer");
            return new Disk[0];
        }
        return disks.getDisks(EnumSet.noneOf(Flags.class));
    }

    protected static ListArea.Params<Disk> createParams(final Luwrain luwrain, String name) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)name, (String)"name");
        ListArea.Params<Disk> params = new ListArea.Params<Disk>();
        params.context = new DefaultControlContext(luwrain);
        params.name = name;
        params.model = new ListUtils.FixedModel<Disk>(DisksPopup.getDisks(luwrain)){

            @Override
            public void refresh() {
                this.setItems(DisksPopup.getDisks(luwrain));
            }
        };
        params.appearance = new ListUtils.DefaultAppearance<Disk>((ControlContext)new DefaultControlContext(luwrain)){

            @Override
            public void announceItem(Disk disk, Set<ListArea.Appearance.Flags> flags) {
                DisksPopup.announceDisk(luwrain, disk, flags);
            }
        };
        params.flags = EnumSet.of(ListArea.Flags.EMPTY_LINE_TOP);
        return params;
    }

    public static interface Disk {
        public File activate(Set<Flags> var1);

        public boolean isActivated();

        public boolean deactivate(Set<Flags> var1);

        default public boolean poweroff(Set<Flags> flags) {
            return false;
        }
    }

    public static enum Flags {
        READ_ONLY;

    }

    public static interface Factory {
        public Disks newDisks(Luwrain var1);
    }

    public static interface Disks {
        public Disk[] getDisks(Set<Flags> var1);
    }
}

