/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.speech;

import org.luwrain.core.EventResponse;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Speech;
import org.luwrain.core.speech.SpeakingText;
import org.luwrain.i18n.I18n;

public final class EventResponseSpeech
implements EventResponse.Speech {
    private final Speech speech;
    private final I18n i18n;
    private final SpeakingText speakableText;

    public EventResponseSpeech(Speech speech, I18n i18n, SpeakingText speakableText) {
        NullCheck.notNull((Object)speech, (String)"speech");
        NullCheck.notNull((Object)i18n, (String)"i18n");
        NullCheck.notNull((Object)speakableText, (String)"speakableText");
        this.speech = speech;
        this.i18n = i18n;
        this.speakableText = speakableText;
    }

    @Override
    public void speak(String[] parts) {
        NullCheck.notNullItems((Object[])parts, (String)"parts");
        if (parts.length == 0) {
            return;
        }
        if (parts.length == 1) {
            this.speech.speakEventResponse(this.speakableText.processEventResponse(parts[0]));
            return;
        }
        StringBuilder b = new StringBuilder();
        b.append(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            b.append(", ").append(parts[i]);
        }
        this.speech.speakEventResponse(this.speakableText.processEventResponse(new String(b)));
    }

    @Override
    public void speakLetter(char letter) {
        String value = this.i18n.hasSpecialNameOfChar(letter);
        if (value == null) {
            this.speech.speakLetter(letter, 0, 0);
        } else {
            this.speech.speak(value, 0, 0);
        }
    }
}

