/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.properties;

import java.util.EnumSet;
import java.util.Set;
import org.luwrain.core.BrailleImpl;
import org.luwrain.core.NullCheck;
import org.luwrain.core.PropertiesProvider;

public final class Braille
implements PropertiesProvider {
    private final BrailleImpl braille;
    private PropertiesProvider.Listener listener = null;

    public Braille(BrailleImpl braille) {
        NullCheck.notNull((Object)braille, (String)"braille");
        this.braille = braille;
    }

    @Override
    public String getExtObjName() {
        return this.getClass().getName();
    }

    @Override
    public String[] getPropertiesRegex() {
        return new String[]{"^luwrain \\.braille\\."};
    }

    @Override
    public Set<PropertiesProvider.Flags> getPropertyFlags(String propName) {
        return EnumSet.of(PropertiesProvider.Flags.PUBLIC);
    }

    @Override
    public String getProperty(String propName) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        switch (propName) {
            case "luwrain.braille.active": {
                return this.braille.isActive() ? "1" : "0";
            }
            case "luwrain.braille.driver": {
                return this.braille.getDriver();
            }
            case "luwrain.braille.error": {
                return this.braille.getErrorMessage();
            }
            case "luwrain.braille.displaywidth": {
                return "" + this.braille.getDisplayWidth();
            }
            case "luwrain.braille.displayheight": {
                return "" + this.braille.getDisplayHeight();
            }
        }
        return null;
    }

    @Override
    public boolean setProperty(String propName, String value) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        NullCheck.notNull((Object)value, (String)"value");
        return false;
    }

    @Override
    public void setListener(PropertiesProvider.Listener listener) {
        this.listener = listener;
    }
}

