/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.luwrain.controls.ControlContext;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.core.UniRefInfo;

public final class UniRefUtils {
    private static final String ALIAS = "alias";
    private static final String FILE = "file";

    public static String makeUniRef(String component, String addr) {
        NullCheck.notEmpty((Object)component, (String)"component");
        NullCheck.notNull((Object)addr, (String)"addr");
        return component + ":" + addr;
    }

    public static UniRefInfo make(String str) {
        NullCheck.notNull((Object)str, (String)"str");
        String text = str.trim();
        if (text.isEmpty()) {
            return new UniRefInfo(UniRefInfo.makeValue("empty", ""), "empty", "", "");
        }
        return new UniRefInfo(UniRefInfo.makeValue("static", ""), "static", text, text);
    }

    public static UniRefInfo make(File file) {
        NullCheck.notNull((Object)file, (String)FILE);
        String path = file.getAbsolutePath();
        return new UniRefInfo(UniRefInfo.makeValue(FILE, path), FILE, path, file.getName());
    }

    public static UniRefInfo make(URL url) {
        NullCheck.notNull((Object)url, (String)"url");
        String addr = url.toString();
        return new UniRefInfo(UniRefInfo.makeValue("url", addr), "url", addr, addr);
    }

    public static UniRefInfo make(Luwrain luwrain, Object obj) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)obj, (String)"obj");
        if (obj instanceof UniRefInfo) {
            return (UniRefInfo)obj;
        }
        if (obj instanceof File) {
            return UniRefUtils.make((File)obj);
        }
        if (obj instanceof URL) {
            return UniRefUtils.make((URL)obj);
        }
        if (!(obj instanceof String)) {
            return null;
        }
        String value = (String)obj;
        UniRefInfo uniRefInfo = luwrain.getUniRefInfo(value);
        if (uniRefInfo != null) {
            return uniRefInfo;
        }
        return UniRefUtils.make(value);
    }

    public static UniRefInfo[] make(Luwrain luwrain, Object[] objs) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNullItems((Object[])objs, (String)"objs");
        ArrayList<UniRefInfo> res = new ArrayList<UniRefInfo>();
        for (Object o : objs) {
            UniRefInfo info = UniRefUtils.make(luwrain, o);
            if (info == null) continue;
            res.add(info);
        }
        return res.toArray(new UniRefInfo[res.size()]);
    }

    public static void defaultAnnouncement(ControlContext context, UniRefInfo info, Sounds defaultSound, Suggestions clickableSuggestion) {
        NullCheck.notNull((Object)context, (String)"context");
        NullCheck.notNull((Object)info, (String)"info");
        if (!info.isAvailable()) {
            context.setEventResponse(DefaultEventResponse.listItem(defaultSound != null ? defaultSound : Sounds.LIST_ITEM, UniRefUtils.getDefaultAnnouncementText(context, info), null));
            return;
        }
        switch (info.getType()) {
            case "static": {
                context.setEventResponse(DefaultEventResponse.listItem(defaultSound != null ? defaultSound : Sounds.LIST_ITEM, UniRefUtils.getDefaultAnnouncementText(context, info), null));
                break;
            }
            case "section": {
                context.setEventResponse(DefaultEventResponse.listItem(Sounds.DOC_SECTION, UniRefUtils.getDefaultAnnouncementText(context, info), null));
                break;
            }
            case "empty": {
                context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
                break;
            }
            default: {
                context.setEventResponse(DefaultEventResponse.listItem(defaultSound != null ? defaultSound : Sounds.LIST_ITEM, UniRefUtils.getDefaultAnnouncementText(context, info), clickableSuggestion));
                return;
            }
        }
    }

    public static String getDefaultAnnouncementText(ControlContext context, UniRefInfo uniRefInfo) {
        NullCheck.notNull((Object)context, (String)"context");
        NullCheck.notNull((Object)uniRefInfo, (String)"uniRefInfo");
        if (!uniRefInfo.isAvailable()) {
            return context.getSpeakableText(uniRefInfo.getValue(), Luwrain.SpeakableTextType.NATURAL);
        }
        switch (uniRefInfo.getType()) {
            case "file": 
            case "url": {
                return context.getSpeakableText(uniRefInfo.getTitle(), Luwrain.SpeakableTextType.PROGRAMMING);
            }
        }
        return context.getSpeakableText(uniRefInfo.getTitle(), Luwrain.SpeakableTextType.NATURAL);
    }

    public static String makeAlias(String title, String uniRef) {
        NullCheck.notEmpty((Object)title, (String)"title");
        NullCheck.notNull((Object)uniRef, (String)"uniRef");
        return "alias:" + title.replaceAll(":", "\\\\:") + ":" + uniRef;
    }

    static boolean isAlias(String uniref) {
        NullCheck.notNull((Object)uniref, (String)"uniref");
        if (uniref.isEmpty()) {
            return false;
        }
        return uniref.startsWith("alias:");
    }

    private static int findAliasDelim(String aliasBody) {
        int delim;
        NullCheck.notNull((Object)aliasBody, (String)"aliasBody");
        for (delim = 0; delim < aliasBody.length() && (aliasBody.charAt(delim) != ':' || delim > 0 && aliasBody.charAt(delim - 1) == '\\'); ++delim) {
        }
        return delim < aliasBody.length() ? delim : -1;
    }
}

