/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.AppManager;
import org.luwrain.core.Application;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Base;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Tile;
import org.luwrain.core.Tiles;

final class TilesManager {
    final AppManager apps;
    private boolean activePopup = false;

    TilesManager(AppManager apps) {
        NullCheck.notNull((Object)apps, (String)"apps");
        this.apps = apps;
    }

    boolean setPopupActive() {
        if (!this.isPopupOpened()) {
            return false;
        }
        this.activePopup = true;
        return true;
    }

    void updatePopupState() {
        if (this.activePopup) {
            if (!this.isPopupOpened()) {
                this.activePopup = false;
            }
        } else if (this.apps.getFrontActiveAreaForActiveApp() == null && this.isPopupOpened()) {
            this.activePopup = true;
        }
    }

    Area getActiveArea() {
        if (this.isPopupActive()) {
            return this.apps.getFrontAreaOfTopPopup();
        }
        Area activeArea = this.apps.getFrontActiveAreaForActiveApp();
        if (activeArea != null) {
            return activeArea;
        }
        if (this.isPopupOpened()) {
            this.activePopup = true;
            return this.apps.getFrontAreaOfTopPopup();
        }
        return null;
    }

    boolean isPopupActive() {
        if (!this.activePopup) {
            return false;
        }
        if (this.isPopupOpened()) {
            return true;
        }
        this.activePopup = false;
        return false;
    }

    void activateNextArea() {
        int index;
        Area activeArea = this.getActiveArea();
        if (activeArea == null) {
            return;
        }
        Object[] objs = this.getWindows().getObjects();
        Tile[] tiles = new Tile[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            tiles[i] = (Tile)objs[i];
        }
        if (tiles == null || tiles.length <= 0) {
            this.activePopup = this.isPopupOpened();
            return;
        }
        for (index = 0; index < tiles.length && tiles[index].area != activeArea; ++index) {
        }
        if (++index >= tiles.length) {
            index = 0;
        }
        this.activePopup = tiles[index].popup;
        if (!this.activePopup) {
            this.apps.setActiveAreaForApp(tiles[index].app, tiles[index].area);
            this.apps.setActiveApp(tiles[index].app);
        }
    }

    Tiles getWindows() {
        Application activeApp = this.apps.getActiveApp();
        Tiles windows = activeApp != null ? this.constructLayoutOfApp(activeApp) : new Tiles();
        if (this.isPopupOpened()) {
            Tile popupWindow = new Tile(this.apps.getAppOfLastPopup(), this.apps.getFrontAreaOfTopPopup(), this.apps.getPositionOfTopPopup());
            switch (popupWindow.popupPos) {
                case BOTTOM: {
                    windows.addBottom(popupWindow);
                    break;
                }
                case TOP: {
                    windows.addTop(popupWindow);
                    break;
                }
                case LEFT: {
                    windows.addLeftSide(popupWindow);
                    break;
                }
                case RIGHT: {
                    windows.addRightSide(popupWindow);
                }
            }
        }
        return windows;
    }

    private boolean isPopupOpened() {
        if (!this.apps.hasAnyPopup()) {
            return false;
        }
        Application app = this.apps.getAppOfLastPopup();
        if (app == null) {
            return true;
        }
        return this.apps.isActiveApp(app);
    }

    private Tiles constructLayoutOfApp(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        AreaLayout layout = this.apps.getFrontAreaLayout(app);
        if (layout == null) {
            Base.warn("got null area layout for the application " + app.getClass().getName());
            return null;
        }
        Tiles tiles = new Tiles();
        switch (layout.layoutType) {
            case SINGLE: {
                tiles.createSingle(new Tile(app, layout.area1));
                break;
            }
            case LEFT_RIGHT: {
                tiles.createLeftRight(new Tile(app, layout.area1), new Tile(app, layout.area2));
                break;
            }
            case TOP_BOTTOM: {
                tiles.createTopBottom(new Tile(app, layout.area1), new Tile(app, layout.area2));
                break;
            }
            case LEFT_TOP_BOTTOM: {
                tiles.createLeftTopBottom(new Tile(app, layout.area1), new Tile(app, layout.area2), new Tile(app, layout.area3));
                break;
            }
            case LEFT_RIGHT_BOTTOM: {
                tiles.createLeftRightBottom(new Tile(app, layout.area1), new Tile(app, layout.area2), new Tile(app, layout.area3));
            }
        }
        return tiles;
    }
}

