/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.Tile;
import org.luwrain.core.TileVisitor;

final class Tiles {
    private Node nodes;

    Tiles() {
    }

    void createSingle(Tile tile) {
        this.nodes = new LeafNode(tile);
    }

    void createLeftRight(Tile tile1, Tile tile2) {
        LeafNode node1 = new LeafNode(tile1);
        LeafNode node2 = new LeafNode(tile2);
        this.nodes = new CompositeNode(Orientation.HORIZ, node1, node2);
    }

    void createTopBottom(Tile tile1, Tile tile2) {
        LeafNode node1 = new LeafNode(tile1);
        LeafNode node2 = new LeafNode(tile2);
        this.nodes = new CompositeNode(Orientation.VERT, node1, node2);
    }

    void createLeftTopBottom(Tile tile1, Tile tile2, Tile tile3) {
        LeafNode node1 = new LeafNode(tile1);
        LeafNode node2 = new LeafNode(tile2);
        LeafNode node3 = new LeafNode(tile3);
        CompositeNode rightSide = new CompositeNode(Orientation.VERT, node2, node3);
        this.nodes = new CompositeNode(Orientation.HORIZ, node1, rightSide);
    }

    void createLeftRightBottom(Tile tile1, Tile tile2, Tile tile3) {
        LeafNode node1 = new LeafNode(tile1);
        LeafNode node2 = new LeafNode(tile2);
        LeafNode node3 = new LeafNode(tile3);
        CompositeNode top = new CompositeNode(Orientation.HORIZ, node1, node2);
        this.nodes = new CompositeNode(Orientation.VERT, top, node3);
    }

    void createHorizontally(Tile[] tiles) {
        if (tiles == null || tiles.length == 0) {
            this.nodes = null;
            return;
        }
        if (tiles.length == 1) {
            this.nodes = new LeafNode(tiles[0]);
            return;
        }
        LeafNode node1 = new LeafNode(tiles[0]);
        LeafNode node2 = new LeafNode(tiles[1]);
        CompositeNode node = new CompositeNode(Orientation.HORIZ, node1, node2);
        for (int i = 2; i < tiles.length; ++i) {
            node = new CompositeNode(Orientation.HORIZ, node, new LeafNode(tiles[i]));
        }
        this.nodes = node;
    }

    void createVertically(Tile[] tiles) {
        if (tiles == null || tiles.length == 0) {
            this.nodes = null;
            return;
        }
        if (tiles.length == 1) {
            this.nodes = new LeafNode(tiles[0]);
            return;
        }
        LeafNode node1 = new LeafNode(tiles[0]);
        LeafNode node2 = new LeafNode(tiles[1]);
        CompositeNode node = new CompositeNode(Orientation.VERT, node1, node2);
        for (int i = 2; i < tiles.length; ++i) {
            node = new CompositeNode(Orientation.VERT, node, new LeafNode(tiles[i]));
        }
        this.nodes = node;
    }

    void addTop(Tile tile) {
        if (tile == null) {
            return;
        }
        if (this.nodes == null) {
            this.nodes = new LeafNode(tile);
            return;
        }
        this.nodes = new CompositeNode(Orientation.VERT, new LeafNode(tile), this.nodes);
    }

    void addBottom(Tile tile) {
        if (tile == null) {
            return;
        }
        if (this.nodes == null) {
            this.nodes = new LeafNode(tile);
            return;
        }
        this.nodes = new CompositeNode(Orientation.VERT, this.nodes, new LeafNode(tile));
    }

    void addLeftSide(Tile tile) {
        if (tile == null) {
            return;
        }
        if (this.nodes == null) {
            this.nodes = new LeafNode(tile);
            return;
        }
        this.nodes = new CompositeNode(Orientation.HORIZ, this.nodes, new LeafNode(tile));
    }

    void addRightSide(Tile tile) {
        if (tile == null) {
            return;
        }
        if (this.nodes == null) {
            this.nodes = new LeafNode(tile);
            return;
        }
        this.nodes = new CompositeNode(Orientation.HORIZ, new LeafNode(tile), this.nodes);
    }

    void replace(Tile tile, Tiles replaceWith) {
        if (tile == null || replaceWith == null || replaceWith.nodes == null) {
            return;
        }
        this.nodes = this.replaceImpl(this.nodes, tile, replaceWith.nodes);
    }

    private Node replaceImpl(Node node, Tile tile, Node replaceWith) {
        if (node == null) {
            return null;
        }
        if (node instanceof LeafNode) {
            LeafNode leaf = (LeafNode)node;
            return leaf.tile == tile ? replaceWith : leaf;
        }
        CompositeNode composite = (CompositeNode)node;
        composite.node1 = this.replaceImpl(composite.node1, tile, replaceWith);
        composite.node2 = this.replaceImpl(composite.node2, tile, replaceWith);
        return composite;
    }

    void clear() {
        this.nodes = null;
    }

    Object[] getObjects() {
        return this.getObjectsImpl(this.nodes);
    }

    private Object[] getObjectsImpl(Node node) {
        int i;
        if (node == null) {
            return new Object[0];
        }
        if (node instanceof LeafNode) {
            LeafNode leaf = (LeafNode)node;
            Object[] o = new Tile[]{leaf.tile};
            return o;
        }
        CompositeNode composite = (CompositeNode)node;
        Object[] o1 = this.getObjectsImpl(composite.node1);
        Object[] o2 = this.getObjectsImpl(composite.node2);
        Object[] o = new Object[o1.length + o2.length];
        for (i = 0; i < o1.length; ++i) {
            o[i] = o1[i];
        }
        for (i = 0; i < o2.length; ++i) {
            o[o1.length + i] = o2[i];
        }
        return o;
    }

    void enumerate(TileVisitor it) {
        this.enumerateImpl(this.nodes, it);
    }

    private void enumerateImpl(Node node, TileVisitor it) {
        if (node == null) {
            return;
        }
        if (node instanceof CompositeNode) {
            CompositeNode compositeNode = (CompositeNode)node;
            this.enumerateImpl(compositeNode.node1, it);
            this.enumerateImpl(compositeNode.node2, it);
            return;
        }
        if (node instanceof LeafNode) {
            LeafNode leaf = (LeafNode)node;
            LeafNode leafNode = (LeafNode)node;
            it.onTile(leafNode.tile);
            return;
        }
    }

    int countLeaves() {
        return this.countLeavesImpl(this.nodes);
    }

    private int countLeavesImpl(Node node) {
        if (node == null) {
            return 0;
        }
        if (node instanceof LeafNode) {
            return 1;
        }
        CompositeNode composite = (CompositeNode)node;
        composite.leafCount = this.countLeavesImpl(composite.node1) + this.countLeavesImpl(composite.node2);
        return composite.leafCount;
    }

    Object getRoot() {
        return this.nodes;
    }

    static boolean isLeaf(Object o) {
        if (o == null) {
            return false;
        }
        Node n = (Node)o;
        return n instanceof LeafNode;
    }

    int getLeafCount(Object o) {
        if (o == null) {
            return 0;
        }
        Node n = (Node)o;
        if (n instanceof LeafNode) {
            return 1;
        }
        CompositeNode c = (CompositeNode)n;
        return c.leafCount;
    }

    Object getBranch1(Object o) {
        if (o == null) {
            return null;
        }
        CompositeNode n = (CompositeNode)o;
        return n.node1;
    }

    Object getBranch2(Object o) {
        if (o == null) {
            return null;
        }
        CompositeNode n = (CompositeNode)o;
        return n.node2;
    }

    Orientation getOrientation(Object o) {
        if (o == null) {
            return Orientation.HORIZ;
        }
        CompositeNode n = (CompositeNode)o;
        return n.orientation;
    }

    Object getLeafObject(Object o) {
        if (o == null) {
            return null;
        }
        LeafNode n = (LeafNode)o;
        return n.tile;
    }

    static final class LeafNode
    extends Node {
        final Tile tile;

        LeafNode(Tile tile) {
            this.tile = tile;
        }
    }

    static abstract class Node {
        Node() {
        }
    }

    static final class CompositeNode
    extends Node {
        final Orientation orientation;
        Node node1;
        Node node2;
        int leafCount = 0;

        CompositeNode(Orientation orientation, Node node1, Node node2) {
            this.orientation = orientation;
            this.node1 = node1;
            this.node2 = node2;
        }
    }

    static enum Orientation {
        HORIZ,
        VERT;

    }
}

