/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.Application;
import org.luwrain.core.Shortcut;

public class DefaultShortcut
implements Shortcut {
    private static final Logger log = LogManager.getLogger();
    protected final String shortcutName;
    protected final Class appClass;
    protected final Set<Shortcut.Flags> flags;
    protected final String[] fileExtensions;

    public DefaultShortcut(String shortcutName, Class appClass, Set<Shortcut.Flags> flags, String[] fileExtensions) {
        Objects.requireNonNull(shortcutName, "shortcutName can't be null");
        Objects.requireNonNull(appClass, "appClass can't be null");
        if (shortcutName.isEmpty()) {
            throw new IllegalArgumentException("shortcutName can't be empty");
        }
        this.shortcutName = shortcutName;
        this.appClass = appClass;
        this.flags = flags;
        this.fileExtensions = (String[])fileExtensions.clone();
    }

    public DefaultShortcut(String shortcutName, Class appClass) {
        Objects.requireNonNull(shortcutName, "shortcutName can't be null");
        Objects.requireNonNull(appClass, "appClass can't be null");
        if (shortcutName.isEmpty()) {
            throw new IllegalArgumentException("shortcutName can't be empty");
        }
        this.shortcutName = shortcutName;
        this.appClass = appClass;
        this.flags = EnumSet.noneOf(Shortcut.Flags.class);
        this.fileExtensions = new String[0];
    }

    @Override
    public String getExtObjName() {
        return this.shortcutName;
    }

    @Override
    public Application[] prepareApp(String[] args) {
        Objects.requireNonNull(args, "args can't be null");
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            throw new NullPointerException("args[" + i + "] can't be null");
        }
        try {
            Object o = this.appClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (o == null || !(o instanceof Application)) {
                log.error("Unable to create new instance of the class " + this.appClass.getName() + " for the shortcut '" + this.shortcutName + "': the result is null or is not an instance of org.luwrain.core.Application");
                return new Application[0];
            }
            return new Application[]{(Application)o};
        }
        catch (Exception e) {
            log.error("Unable to create new instance of the class " + this.appClass.getName() + " for the shortcut '" + this.shortcutName, (Throwable)e);
            return new Application[0];
        }
    }

    @Override
    public Set<Shortcut.Flags> getShortcutFlags() {
        return this.flags;
    }

    @Override
    public String[] getFileExtensions() {
        return (String[])this.fileExtensions.clone();
    }
}

