/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.ArrayList;
import org.luwrain.core.NullCheck;

public final class CmdLine {
    private final String[] cmdLine;

    public CmdLine(String[] cmdLine) {
        NullCheck.notNullItems((Object[])cmdLine, (String)"cmdLine");
        this.cmdLine = (String[])cmdLine.clone();
    }

    public boolean used(String option) {
        NullCheck.notNull((Object)option, (String)"option");
        for (String s : this.cmdLine) {
            if (!s.equals(option)) continue;
            return true;
        }
        return false;
    }

    public String getFirstArg(String prefix) {
        NullCheck.notEmpty((Object)prefix, (String)"prefix");
        for (String s : this.cmdLine) {
            if (s.length() < prefix.length() || !s.startsWith(prefix)) continue;
            return s.substring(prefix.length());
        }
        return null;
    }

    public String[] getArgs(String prefix) {
        NullCheck.notNull((Object)prefix, (String)"prefix");
        ArrayList<String> res = new ArrayList<String>();
        for (String s : this.cmdLine) {
            if (s.length() < prefix.length() || !s.startsWith(prefix)) continue;
            res.add(s.substring(prefix.length()));
        }
        return res.toArray(new String[res.size()]);
    }
}

