/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.wizard;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.luwrain.controls.WizardArea;
import org.luwrain.controls.wizard.FrameDelegate;
import org.luwrain.core.Luwrain;

public class WizardGroovyController {
    final Luwrain luwrain;
    final WizardArea area;
    final Map<String, WizardArea.Frame> frames = new HashMap<String, WizardArea.Frame>();

    public WizardGroovyController(Luwrain luwrain, WizardArea area) {
        this.luwrain = Objects.requireNonNull(luwrain, "luwrain can't be null");
        this.area = Objects.requireNonNull(area, "area can't be null");
    }

    public void call(String title, String firstFrame, Closure frames) {
        Objects.requireNonNull(title, "title can't be null");
        Objects.requireNonNull(firstFrame, "firstFrame can't be null");
        Objects.requireNonNull(frames, "frames can't be null");
        if (firstFrame.isEmpty()) {
            throw new IllegalArgumentException("firstFrame can't be empty");
        }
        frames.setDelegate((Object)this);
        frames.call();
        WizardArea.Frame frame = this.frames.get(firstFrame);
        if (frame == null) {
            throw new IllegalArgumentException("No first frame: " + firstFrame);
        }
        this.area.show(frame);
    }

    public void frame(String id, Closure closure) {
        Objects.requireNonNull(id, "id can't be null");
        Objects.requireNonNull(closure, "closure can't be null");
        if (id.isEmpty()) {
            throw new IllegalArgumentException("id can't be empty");
        }
        WizardArea.Frame f = this.area.newFrame();
        FrameDelegate d = new FrameDelegate(this, f);
        closure.setDelegate((Object)d);
        closure.call();
        this.frames.put(id, f);
    }
}

