/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.list;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Sounds;

public abstract class DoubleLevelAppearance<E>
implements ListArea.Appearance<E> {
    protected final ControlContext context;

    public DoubleLevelAppearance(ControlContext context) {
        this.context = Objects.requireNonNull(context, "context can't be null");
    }

    public abstract boolean isSectionItem(E var1);

    public void announceNonSection(E item) {
        Objects.requireNonNull(item, "item can't be null");
        this.context.setEventResponse(DefaultEventResponse.listItem(this.getNonSectionScreenAppearance(item)));
    }

    public String getNonSectionScreenAppearance(E item) {
        Objects.requireNonNull(item, "item can't be null");
        return item.toString();
    }

    public void announceSection(E item) {
        Objects.requireNonNull(item, "item can't be null");
        this.context.playSound(Sounds.DOC_SECTION);
        this.context.say(this.getSectionScreenAppearance(item));
    }

    public String getSectionScreenAppearance(E item) {
        Objects.requireNonNull(item, "item");
        return item.toString();
    }

    @Override
    public void announceItem(E item, Set<ListArea.Appearance.Flags> flags) {
        Objects.requireNonNull(item, "item can't be null");
        Objects.requireNonNull(flags, "flags can't be null");
        if (this.isSectionItem(item)) {
            this.announceSection(item);
        } else {
            this.announceNonSection(item);
        }
    }

    @Override
    public String getScreenAppearance(E item, Set<ListArea.Appearance.Flags> flags) {
        Objects.requireNonNull(item, "item can't be null");
        Objects.requireNonNull(flags, "flags can't be null");
        if (this.isSectionItem(item)) {
            return this.getSectionScreenAppearance(item);
        }
        return "  " + this.getNonSectionScreenAppearance(item);
    }

    @Override
    public int getObservableLeftBound(E item) {
        Objects.requireNonNull(item, "item can't be null");
        if (this.isSectionItem(item)) {
            return 0;
        }
        return 2;
    }

    @Override
    public int getObservableRightBound(E item) {
        Objects.requireNonNull(item, "item");
        return this.getScreenAppearance(item, EnumSet.noneOf(ListArea.Appearance.Flags.class)).length();
    }
}

