/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.edit;

import java.util.Objects;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;

public class DefaultMultilineEditAppearance
implements MultilineEdit.Appearance {
    protected final ControlContext context;

    public DefaultMultilineEditAppearance(ControlContext context) {
        Objects.requireNonNull(context, "context can't be null can't be null");
        this.context = context;
    }

    @Override
    public boolean onBackspaceTextBegin() {
        this.context.setEventResponse(DefaultEventResponse.hint(Hint.BEGIN_OF_TEXT));
        return true;
    }

    @Override
    public boolean onBackspaceMergeLines(MultilineEdit.ModificationResult res) {
        Objects.requireNonNull(res, "res can't be null");
        if (!res.isPerformed()) {
            return false;
        }
        this.context.setEventResponse(DefaultEventResponse.hint(Hint.LINE_BOUND));
        return true;
    }

    @Override
    public boolean onBackspaceDeleteChar(MultilineEdit.ModificationResult res) {
        Objects.requireNonNull(res, "res can't be null");
        if (!res.isPerformed() || res.getCharArg() == '\u0000') {
            return false;
        }
        this.context.setEventResponse(DefaultEventResponse.letter(res.getCharArg()));
        return true;
    }

    @Override
    public boolean onDeleteChar(MultilineEdit.ModificationResult res) {
        Objects.requireNonNull(res, "res can't be null");
        if (!res.isPerformed() || res.getCharArg() == '\u0000') {
            return false;
        }
        this.context.setEventResponse(DefaultEventResponse.letter(res.getCharArg()));
        return true;
    }

    @Override
    public boolean onDeleteCharTextEnd() {
        this.context.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_TEXT));
        return true;
    }

    @Override
    public boolean onDeleteCharMergeLines(MultilineEdit.ModificationResult res) {
        Objects.requireNonNull(res, "res can't be null");
        if (!res.isPerformed()) {
            return false;
        }
        this.context.setEventResponse(DefaultEventResponse.hint(Hint.LINE_BOUND));
        return true;
    }

    @Override
    public boolean onTab(MultilineEdit.ModificationResult res) {
        Objects.requireNonNull(res, "res can't be null");
        if (!res.isPerformed()) {
            return false;
        }
        this.context.setEventResponse(DefaultEventResponse.hint(Hint.TAB));
        return true;
    }

    @Override
    public boolean onSplitLines(MultilineEdit.ModificationResult res) {
        Objects.requireNonNull(res, "res can't be null");
        if (!res.isPerformed()) {
            return false;
        }
        String line = res.getStringArg();
        if (line == null || line.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
        } else if (line.trim().isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.SPACES));
        } else {
            this.context.setEventResponse(DefaultEventResponse.text(line));
        }
        return true;
    }

    @Override
    public boolean onChar(MultilineEdit.ModificationResult res) {
        Objects.requireNonNull(res, "res can't be null");
        if (!res.isPerformed()) {
            return false;
        }
        if (Character.isWhitespace(res.getCharArg())) {
            String word = res.getStringArg();
            if (word != null && !word.trim().isEmpty()) {
                this.context.setEventResponse(DefaultEventResponse.text(word));
            } else {
                this.context.setEventResponse(DefaultEventResponse.letter(res.getCharArg()));
            }
        } else {
            this.context.setEventResponse(DefaultEventResponse.letter(res.getCharArg()));
        }
        return true;
    }
}

