/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.core.LineMarks;
import org.luwrain.core.MutableLines;
import org.luwrain.core.MutableMarkedLines;
import org.luwrain.core.NullCheck;

public class UndoLines
implements MutableMarkedLines {
    protected final MutableLines lines;
    protected final List<Command> commands = new ArrayList<Command>();

    public UndoLines(MutableLines lines) {
        NullCheck.notNull((Object)lines, (String)"lines");
        this.lines = lines;
    }

    @Override
    public int getLineCount() {
        return this.lines.getLineCount();
    }

    @Override
    public String getLine(int index) {
        return this.lines.getLine(index);
    }

    @Override
    public void update(MutableLines.Updating updating) {
    }

    @Override
    public String[] getLines() {
        return this.lines.getLines();
    }

    @Override
    public void setLines(String[] lines) {
    }

    @Override
    public void addLine(String line) {
        NullCheck.notNull((Object)line, (String)"line");
        AddLine cmd = new AddLine(this.lines, line);
        ((Command)cmd).redo(this.lines);
        this.saveCommand(cmd);
    }

    @Override
    public void insertLine(int index, String line) {
    }

    @Override
    public void removeLine(int index) {
        RemoveLine cmd = new RemoveLine(this.lines, index);
        ((Command)cmd).redo(this.lines);
        this.saveCommand(cmd);
    }

    @Override
    public void setLine(int index, String line) {
    }

    @Override
    public void clear() {
    }

    @Override
    public LineMarks getLineMarks(int index) {
        return null;
    }

    @Override
    public void setLineMarks(int index, LineMarks lineMarks) {
    }

    protected void saveCommand(Command command) {
        NullCheck.notNull((Object)command, (String)"command");
        this.commands.add(command);
    }

    protected static final class AddLine
    extends Command {
        private final int addedLineIndex;
        private final String line;

        public AddLine(MutableLines lines, String line) {
            NullCheck.notNull((Object)lines, (String)"lines");
            NullCheck.notNull((Object)line, (String)"line");
            this.addedLineIndex = lines.getLineCount();
            this.line = line;
        }

        @Override
        public void redo(MutableLines lines) {
            NullCheck.notNull((Object)lines, (String)"lines");
            lines.addLine(this.line);
        }

        @Override
        public void undo(MutableLines lines) {
            NullCheck.notNull((Object)lines, (String)"lines");
            lines.removeLine(this.addedLineIndex);
        }
    }

    protected static abstract class Command {
        protected Command() {
        }

        public abstract void redo(MutableLines var1);

        public abstract void undo(MutableLines var1);
    }

    protected static final class RemoveLine
    extends Command {
        private final int removingLineIndex;
        private final String line;

        public RemoveLine(MutableLines lines, int index) {
            NullCheck.notNull((Object)lines, (String)"lines");
            if (index < 0 || index >= lines.getLineCount()) {
                throw new IllegalArgumentException("index (" + String.valueOf(index) + ") must be non-negative and less than " + String.valueOf(lines.getLineCount()));
            }
            this.removingLineIndex = lines.getLineCount();
            this.line = lines.getLine(index);
        }

        @Override
        public void redo(MutableLines lines) {
            NullCheck.notNull((Object)lines, (String)"lines");
            lines.removeLine(this.removingLineIndex);
        }

        @Override
        public void undo(MutableLines lines) {
            NullCheck.notNull((Object)lines, (String)"lines");
            lines.insertLine(this.removingLineIndex, this.line);
        }
    }
}

