/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.List;
import org.luwrain.controls.ConsoleArea;
import org.luwrain.core.NullCheck;

public final class ConsoleUtils {

    public static class ListModel<E>
    implements ConsoleArea.Model<E> {
        protected final List<E> source;

        public ListModel(List<E> source) {
            NullCheck.notNull(source, (String)"source");
            this.source = source;
        }

        @Override
        public int getItemCount() {
            return this.source.size();
        }

        @Override
        public E getItem(int index) {
            if (index < 0 || index >= this.source.size()) {
                throw new IllegalArgumentException("Illegal index: " + String.valueOf(index));
            }
            return this.source.get(index);
        }
    }

    public static class ArrayModel<E>
    implements ConsoleArea.Model<E> {
        protected final Source<E> source;

        public ArrayModel(Source<E> source) {
            NullCheck.notNull(source, (String)"source");
            this.source = source;
        }

        @Override
        public int getItemCount() {
            E[] o = this.source.getItems();
            return o != null ? o.length : 0;
        }

        @Override
        public E getItem(int index) {
            E[] o = this.source.getItems();
            if (o == null) {
                throw new IllegalStateException("No items");
            }
            if (index < 0 || index >= o.length) {
                throw new IllegalArgumentException("Illegal index: " + String.valueOf(index));
            }
            return o[index];
        }

        public static interface Source<E> {
            public E[] getItems();
        }
    }
}

