/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.objects.filters;

import java.util.Arrays;
import java.util.Set;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.filters.Filters;
import org.dizitart.no2.objects.ObjectFilter;
import org.dizitart.no2.objects.filters.BaseObjectFilter;
import org.dizitart.no2.store.NitriteMap;

class OrObjectFilter
extends BaseObjectFilter {
    private ObjectFilter[] filters;

    OrObjectFilter(ObjectFilter ... filters) {
        this.filters = filters;
    }

    @Override
    public Set<NitriteId> apply(NitriteMap<NitriteId, Document> documentMap) {
        for (ObjectFilter filter : this.filters) {
            filter.setNitriteService(this.nitriteService);
            filter.setNitriteMapper(this.nitriteMapper);
        }
        Filter or = Filters.or(this.filters);
        or.setNitriteService(this.nitriteService);
        return or.apply(documentMap);
    }

    public ObjectFilter[] getFilters() {
        return this.filters;
    }

    public String toString() {
        return "OrObjectFilter(filters=" + Arrays.deepToString(this.getFilters()) + ")";
    }
}

