/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dizitart.no2.Document;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.filters.BaseFilter;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.DocumentUtils;
import org.dizitart.no2.util.ValidationUtils;

class NotInFilter
extends BaseFilter {
    private String field;
    private Object[] values;
    private Set<Object> objectList;

    NotInFilter(String field, Object ... values) {
        this.field = field;
        this.values = values;
        this.objectList = new HashSet<Object>();
        Collections.addAll(this.objectList, values);
    }

    @Override
    public Set<NitriteId> apply(NitriteMap<NitriteId, Document> documentMap) {
        ValidationUtils.validateInFilterValue(this.field, this.values);
        if (this.nitriteService.hasIndex(this.field) && !this.nitriteService.isIndexing(this.field) && this.objectList != null) {
            return this.nitriteService.findNotInWithIndex(this.field, this.objectList);
        }
        return this.matchedSet(documentMap);
    }

    private Set<NitriteId> matchedSet(NitriteMap<NitriteId, Document> documentMap) {
        LinkedHashSet<NitriteId> nitriteIdSet = new LinkedHashSet<NitriteId>();
        for (Map.Entry<NitriteId, Document> entry : documentMap.entrySet()) {
            Document document = entry.getValue();
            Object fieldValue = DocumentUtils.getFieldValue(document, this.field);
            if (this.objectList.contains(fieldValue)) continue;
            nitriteIdSet.add(entry.getKey());
        }
        return nitriteIdSet;
    }

    public String getField() {
        return this.field;
    }

    public Object[] getValues() {
        return this.values;
    }

    public Set<Object> getObjectList() {
        return this.objectList;
    }

    public String toString() {
        return "NotInFilter(field=" + this.getField() + ", values=" + Arrays.deepToString(this.getValues()) + ", objectList=" + this.getObjectList() + ")";
    }
}

