/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.browser;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.browser.Conv;
import org.luwrain.app.browser.MainLayout;
import org.luwrain.app.browser.Strings;
import org.luwrain.app.browser.WebBlock;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Log;
import org.luwrain.core.Sounds;
import org.luwrain.graphical.FxThread;
import org.luwrain.web.WebKitBlock;
import org.luwrain.web.WebKitBlocks;

public final class App
extends AppBase<Strings> {
    static final String LOG_COMPONENT = "browser";
    private static final boolean LOAD_INITIAL = true;
    private final String arg;
    private Conv conv = null;
    private MainLayout mainLayout = null;
    private WebEngine webEngine = null;
    private WebView webView = null;
    private Runnable firstSwitching = null;

    public App() {
        this(null);
    }

    public App(String arg) {
        super(Strings.class);
        this.arg = arg != null ? arg : "";
    }

    protected AreaLayout onAppInit() {
        this.conv = new Conv(this);
        FxThread.runSync(() -> {
            this.webView = new WebView();
            this.webEngine = this.webView.getEngine();
            this.webEngine.setUserDataDirectory(this.getLuwrain().getAppDataDir("luwrain.browser").toFile());
            this.webEngine.getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> this.onStateChanged((ObservableValue<? extends Worker.State>)ov, (Worker.State)oldState, (Worker.State)newState));
            this.webView.setVisible(false);
        });
        this.mainLayout = new MainLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        this.getLuwrain().showGraphical(graphicalModeControl -> {
            this.webView.setOnKeyReleased(event -> {
                switch (event.getCode()) {
                    case ESCAPE: {
                        this.getLuwrain().runUiSafely(() -> this.getLuwrain().playSound(Sounds.OK));
                        graphicalModeControl.close();
                    }
                }
            });
            this.firstSwitching = () -> graphicalModeControl.close();
            this.webView.setVisible(true);
            this.getEngine().load("https://luwrain.org");
            return this.webView;
        });
        return this.mainLayout.getAreaLayout();
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    private void onStateChanged(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
        if (newState == null) {
            return;
        }
        Log.debug((String)LOG_COMPONENT, (String)("browser state changed to " + newState.toString()));
        switch (newState) {
            case SUCCEEDED: {
                if (this.firstSwitching != null) {
                    this.firstSwitching.run();
                    this.firstSwitching = null;
                }
                String title = this.webEngine.getTitle();
                List<WebKitBlock> blocks = new WebKitBlocks(this.webEngine).process(100);
                this.getLuwrain().runUiSafely(() -> {
                    ArrayList b = new ArrayList();
                    b.ensureCapacity(blocks.size());
                    blocks.forEach(i -> {
                        if (i.visible) {
                            b.add(new WebBlock((WebKitBlock)i));
                        }
                    });
                    this.mainLayout.webArea.setBlocks(b.toArray(new WebBlock[b.size()]));
                    this.setAppName(title);
                    this.getLuwrain().playSound(Sounds.OK);
                });
                break;
            }
            case FAILED: {
                this.getLuwrain().runUiSafely(() -> this.getLuwrain().playSound(Sounds.ERROR));
            }
        }
    }

    Conv getConv() {
        return this.conv;
    }

    public WebEngine getEngine() {
        return this.webEngine;
    }

    public WebView getView() {
        return this.webView;
    }
}

