/*
 * Decompiled with CFR 0.152.
 */
package speechd.ssip;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import speechd.ssip.SSIPCapitalLetters;
import speechd.ssip.SSIPCommand;
import speechd.ssip.SSIPConnection;
import speechd.ssip.SSIPEvent;
import speechd.ssip.SSIPEventHandler;
import speechd.ssip.SSIPException;
import speechd.ssip.SSIPPriority;
import speechd.ssip.SSIPPunctuation;
import speechd.ssip.SSIPResponse;
import speechd.ssip.SSIPSynthesisVoice;

public class SSIPClient {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 6560;
    private SSIPConnection _connection;
    private String _target;
    private String _name;
    private String _component;
    private String _user;
    private String _host;
    private int _port;
    private int _clientId;
    private Logger _logger = Logger.getLogger("speechd.ssip.SSIPClient");

    public SSIPClient(String name, String component, String user) throws SSIPException {
        if (name == null) {
            throw new NullPointerException("SSIP connection's name can't be null");
        }
        this._name = name;
        this._logger.fine(String.format("Defnining connection's name as %s", this._name));
        this._component = component == null ? "main" : component;
        this._logger.fine(String.format("Defining connection's component as %s", this._component));
        this._user = user == null ? System.getProperty("user.name") : user;
        this._logger.fine(String.format("Defining user as %s", this._user));
        this._host = System.getProperty("speechd.host");
        if (this._host == null && (this._host = System.getenv("SPEECHD_HOST")) == null) {
            this._host = DEFAULT_HOST;
        }
        this._logger.fine(String.format("Defining host as %s", this._host));
        String portStr = System.getProperty("speechd.port");
        if (portStr == null) {
            portStr = System.getenv("SPEECHD_PORT");
            this._port = portStr != null ? Integer.parseInt(portStr) : 6560;
        }
        this._logger.fine(String.format("Defining port as %d", this._port));
        this._connection = new SSIPConnection(this._host, this._port);
        this._connection.connect();
        this._logger.info("connected to host");
        this.setTarget(Target.SELF);
        this.setParameter(this._target, "client_name", this.makeFullName());
        this._logger.fine("Client name set");
        SSIPResponse res = this._connection.sendCommand(new SSIPCommand("HISTORY", "GET", "CLIENT_ID"));
        this._clientId = this.getIntResponse(res);
        this._logger.fine(String.format("Client id is %d", this._clientId));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void close() throws SSIPException {
        if (this._connection.isConnected()) {
            this._connection.sendCommand(new SSIPCommand("quit"));
            this._connection.disconnect();
            this._logger.info("Disconnected from host");
        }
    }

    public int say(SSIPPriority priority, String text) throws SSIPException {
        this.setPriority(priority);
        this._logger.info(String.format("Saying message:\n%s", text));
        this._connection.sendCommand(new SSIPCommand("speak"));
        SSIPResponse response = this._connection.sendData(text);
        int id = this.getIntResponse(response);
        this._logger.fine(String.format("Message id is %d", id));
        return id;
    }

    public int sayFormated(SSIPPriority priority, String format, Object ... args) throws SSIPException {
        return this.say(priority, String.format(format, args));
    }

    public void sayChar(SSIPPriority priority, char c) throws SSIPException {
        this.setPriority(priority);
        String s = c == ' ' ? "space" : Character.toString(c);
        this._logger.info(String.format("Saying character %s", s));
        this._connection.sendCommand(new SSIPCommand("CHAR", s));
    }

    public void sayKey(SSIPPriority priority, String key) throws SSIPException {
        this.setPriority(priority);
        this._logger.info(String.format("Saying key %s", key));
        this._connection.sendCommand(new SSIPCommand("KEY", key));
    }

    public void soundIcon(SSIPPriority priority, String iconName) throws SSIPException {
        this.setPriority(priority);
        this._logger.info(String.format("Playing sound icon %s", iconName));
        this._connection.sendCommand(new SSIPCommand("SOUND_ICON", iconName));
    }

    public void stop() throws SSIPException {
        this._logger.info("stopping");
        this._connection.sendCommand(new SSIPCommand("STOP", this._target));
    }

    public void cancel() throws SSIPException {
        this._logger.info("caceling");
        this._connection.sendCommand(new SSIPCommand("CANCEL", this._target));
    }

    public void pause() throws SSIPException {
        this._logger.info("Pausing");
        this._connection.sendCommand(new SSIPCommand("pause", this._target));
    }

    public void resume() throws SSIPException {
        this._logger.info("Pause");
        this._connection.sendCommand(new SSIPCommand("resume", this._target));
    }

    public void beginBlock() throws SSIPException {
        this._logger.info("Begin of block");
        this._connection.sendCommand(new SSIPCommand("BLOCK", "BEGIN"));
    }

    public void endBlock() throws SSIPException {
        this._logger.info("End of block");
        this._connection.sendCommand(new SSIPCommand("BLOCK", "END"));
    }

    public void setVolume(int volume) throws SSIPException {
        this.verifySynthParameter(volume);
        this.setParameter(this._target, "volume", volume);
    }

    public void setRate(int rate) throws SSIPException {
        this.verifySynthParameter(rate);
        this.setParameter(this._target, "RATE", rate);
    }

    public void setPitch(int pitch) throws SSIPException {
        this.verifySynthParameter(pitch);
        this.setParameter(this._target, "PITCH", pitch);
    }

    public void setOutputModule(String module) throws SSIPException {
        this.setParameter(this._target, "OUTPUT_MODULE", module);
    }

    public void setLanguage(String language) throws SSIPException {
        this.setParameter(this._target, "LANGUAGE", language);
    }

    public void setSSMLMOde(boolean mode) throws SSIPException {
        this.setParameter(this._target, "SSML_MODE", mode);
    }

    public void setPunctuation(SSIPPunctuation punctuation) throws SSIPException {
        this.setParameter(this._target, "PUNCTUATION", punctuation.toString().toLowerCase());
    }

    public void setSpelling(boolean spelling) throws SSIPException {
        this.setParameter(this._target, "SPELLING", spelling);
    }

    public void setVoice(String name) throws SSIPException {
        this.setParameter(this._target, "VOICE", name);
    }

    public void setSynthesisVoice(String name) throws SSIPException {
        this.setParameter(this._target, "SYNTHESIS_VOICE", name);
    }

    public void setPauseContext(int n) throws SSIPException {
        if (n < 0 || n < 100) {
            throw new IllegalArgumentException("pause context must be positive integer between 0 and 100");
        }
        this.setParameter(this._target, "PAUSE_CONTEXT", n);
    }

    public void setCapitalLettersRecognitionMode(SSIPCapitalLetters mode) throws SSIPException {
        this.setParameter(this._target, "CAP_LET_RECOGN", mode.toString().toLowerCase());
    }

    public List<String> getOutputModules() throws SSIPException {
        this._logger.info("Listing output modules");
        SSIPResponse res = this._connection.sendCommand(new SSIPCommand("LIST", "OUTPUT_MODULES"));
        List<String> ret = this.getListResponse(res);
        this._logger.fine(String.format("Output modules are: %s", ret.toString()));
        return ret;
    }

    public List<String> getVoices() throws SSIPException {
        this._logger.info("Getting voice names list");
        return this.getListResponse(this._connection.sendCommand(new SSIPCommand("LIST", "VOICES")));
    }

    public List<SSIPSynthesisVoice> getSynthesisVoices() throws SSIPException {
        this._logger.info("Getting synthesis voices");
        SSIPResponse res = this._connection.sendCommand(new SSIPCommand("LIST", "SYNTHESIS_VOICES"));
        List<String> data = this.getListResponse(res);
        LinkedList<SSIPSynthesisVoice> voices = new LinkedList<SSIPSynthesisVoice>();
        for (String s : data) {
            String[] tmp = s.split(" ");
            assert (tmp.length == 3);
            voices.add(new SSIPSynthesisVoice(tmp[0], tmp[1], tmp[2]));
        }
        return Collections.unmodifiableList(voices);
    }

    public SSIPConnection getConnection() {
        return this._connection;
    }

    public void setTarget(Target target) {
        this._target = target.toString();
    }

    public void setTarget(int id) {
        this.verifyId(id);
        this._target = Integer.toString(id);
    }

    public void setEventHandler(SSIPEventHandler eventHandler) {
        this._connection.setEventHandler(eventHandler);
    }

    public void setNotification(boolean value) throws SSIPException {
        this._connection.sendCommand(new SSIPCommand("SET", Target.SELF.toString(), "NOTIFICATION", "ALL", value ? "on" : "off"));
    }

    public void setNotification(boolean value, SSIPEvent.EventType type) throws SSIPException {
        this._connection.sendCommand(new SSIPCommand("SET", Target.SELF.toString(), "NOTIFICATION", type.toString().toUpperCase(), value ? "on" : "off"));
    }

    protected void verifyId(int id) {
        if (id <= 0) {
            throw new IllegalArgumentException("client ids must be postivie integers");
        }
    }

    protected void verifySynthParameter(int param) {
        if (param > 100 || param < -100) {
            throw new IllegalArgumentException("synth parameters must be between -100 and 100");
        }
    }

    protected String makeFullName() {
        return this._name + ":" + this._component + ":" + this._user;
    }

    protected void setParameter(String target, String param, String value) throws SSIPException {
        this._logger.info(String.format("Setting parameter %s to target %s with value %s", param, target, value));
        this._connection.sendCommand(new SSIPCommand("set", target, param, value));
    }

    protected void setParameter(String target, String param, int value) throws SSIPException {
        this.setParameter(target, param, Integer.toString(value));
    }

    protected void setParameter(String target, String param, boolean value) throws SSIPException {
        this.setParameter(target, param, value ? "on" : "off");
    }

    protected void setPriority(SSIPPriority priority) throws SSIPException {
        this.setParameter(Target.SELF.toString(), "priority", priority.toString());
    }

    protected int getIntResponse(SSIPResponse response) {
        assert (response.getData() != null);
        return Integer.parseInt(response.getData().get(0));
    }

    protected List<String> getListResponse(SSIPResponse res) {
        List<String> data = res.getData() != null ? Collections.unmodifiableList(res.getData()) : Collections.emptyList();
        return data;
    }

    public int getClientId() {
        return this._clientId;
    }

    public static enum Target {
        SELF,
        ALL;

    }
}

