/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk2;

import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.exceptions.ApiException;
import com.vk.api.sdk.exceptions.ClientException;
import com.vk.api.sdk.objects.account.SaveProfileInfoRelation;
import com.vk.api.sdk.objects.account.responses.SaveProfileInfoResponse;
import com.vk.api.sdk.objects.docs.DocTypes;
import com.vk.api.sdk.objects.docs.responses.GetTypesResponse;
import com.vk.api.sdk.objects.friends.GetOrder;
import com.vk.api.sdk.objects.friends.responses.GetRequestsResponse;
import com.vk.api.sdk.objects.friends.responses.GetResponse;
import com.vk.api.sdk.objects.friends.responses.GetSuggestionsResponse;
import com.vk.api.sdk.objects.likes.Type;
import com.vk.api.sdk.objects.likes.responses.GetListResponse;
import com.vk.api.sdk.objects.messages.ConversationWithMessage;
import com.vk.api.sdk.objects.messages.responses.GetConversationsResponse;
import com.vk.api.sdk.objects.newsfeed.Filters;
import com.vk.api.sdk.objects.photos.responses.GetWallUploadServerResponse;
import com.vk.api.sdk.objects.photos.responses.SaveWallPhotoResponse;
import com.vk.api.sdk.objects.photos.responses.WallUploadResponse;
import com.vk.api.sdk.objects.users.Fields;
import com.vk.api.sdk.objects.users.UserFull;
import com.vk.api.sdk.objects.users.UserSettingsXtr;
import com.vk.api.sdk.objects.wall.WallpostFull;
import com.vk.api.sdk.objects.wall.responses.GetByIdExtendedResponse;
import com.vk.api.sdk.objects.wall.responses.PostResponse;
import com.vk.api.sdk.oneofs.NewsfeedNewsfeedItemOneOf;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.luwrain.app.vk2.App;
import org.luwrain.app.vk2.api.AudioGetUploadServerQuery;
import org.luwrain.app.vk2.api.AudioGetUploadServerResponse;

public final class Operations {
    private static final String LOG_COMPONENT = "vk";
    final App app;
    final VkApiClient vk;
    final UserActor actor;

    Operations(App app) {
        this.app = app;
        this.vk = app.vk;
        this.actor = app.getActor();
    }

    List<NewsfeedNewsfeedItemOneOf> getNews() {
        try {
            com.vk.api.sdk.objects.newsfeed.responses.GetResponse resp = (com.vk.api.sdk.objects.newsfeed.responses.GetResponse)this.vk.newsfeed().get(this.actor).filters(new Filters[]{Filters.POST, Filters.PHOTO}).execute();
            ArrayList<String> ids = new ArrayList<String>();
            for (NewsfeedNewsfeedItemOneOf i : resp.getItems()) {
                if (i.getOneOf1().getSourceId() == null) continue;
                ids.add(i.getOneOf1().getSourceId().toString());
            }
            this.getUsersForCache(ids);
            return resp.getItems();
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    List<WallpostFull> getWallPosts() {
        try {
            com.vk.api.sdk.objects.wall.responses.GetResponse resp = (com.vk.api.sdk.objects.wall.responses.GetResponse)this.vk.wall().get(this.actor).execute();
            ArrayList<WallpostFull> res = new ArrayList<WallpostFull>();
            if (resp != null && resp.getItems() != null) {
                res.addAll(resp.getItems());
            }
            return res;
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    void newWallPost(String text, File[] photos, File[] docs) {
        try {
            ArrayList<CallSite> attachments = new ArrayList<CallSite>();
            for (File f : photos) {
                GetWallUploadServerResponse server = (GetWallUploadServerResponse)this.vk.photos().getWallUploadServer(this.actor).execute();
                WallUploadResponse upload = (WallUploadResponse)this.vk.upload().photoWall(server.getUploadUrl().toString(), f).execute();
                for (SaveWallPhotoResponse p : (List)this.vk.photos().saveWallPhoto(this.actor, upload.getPhoto()).server(upload.getServer()).hash(upload.getHash()).execute()) {
                    attachments.add((CallSite)((Object)("photo" + p.getOwnerId() + "_" + p.getId())));
                }
            }
            PostResponse postResponse = (PostResponse)this.vk.wall().post(this.actor).message(text).attachments(attachments).execute();
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    List<String> getDocTypes(int userId) {
        try {
            GetTypesResponse resp = (GetTypesResponse)this.vk.docs().getTypes(this.actor, userId).execute();
            ArrayList<String> res = new ArrayList<String>();
            for (DocTypes i : resp.getItems()) {
                res.add(i.getName());
            }
            return res;
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    WallpostFull getWallPost(String id) {
        try {
            GetByIdExtendedResponse resp = (GetByIdExtendedResponse)this.vk.wall().getByIdExtended(this.actor, new String[]{id}).execute();
            List items = resp.getItems();
            if (items != null && items.size() == 1) {
                return (WallpostFull)items.get(0);
            }
            return null;
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    List<ConversationWithMessage> getChats() {
        try {
            GetConversationsResponse resp = (GetConversationsResponse)this.vk.messages().getConversations(this.actor).execute();
            List list = resp.getItems();
            ArrayList<String> userIds = new ArrayList<String>();
            for (ConversationWithMessage d : list) {
                userIds.add(d.getLastMessage().getFromId().toString());
                userIds.add(d.getLastMessage().getPeerId().toString());
            }
            List<UserFull> users = this.getUsersForCache(userIds);
            for (UserFull u : users) {
                this.app.userCache.put(u.getId(), u);
            }
            return list;
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public List<UserFull> getFriends(Integer userId) {
        try {
            GetResponse resp = userId != null ? (GetResponse)this.vk.friends().get(this.actor).userId(userId).order(GetOrder.NAME).execute() : (GetResponse)this.vk.friends().get(this.actor).order(GetOrder.NAME).execute();
            List l = resp.getItems();
            Integer[] ids = l.toArray(new Integer[l.size()]);
            return this.getUsersForCache(ids);
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    void newFriendship(int userId) {
        try {
            this.vk.friends().add(this.actor).userId(Integer.valueOf(userId)).execute();
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    List<UserFull> getFriendshipRequests() {
        try {
            GetRequestsResponse requestsResp = (GetRequestsResponse)this.vk.friends().getRequests(this.actor).execute();
            List requestsList = requestsResp.getItems();
            Integer[] requestsIds = requestsList.toArray(new Integer[requestsList.size()]);
            return this.getUsersForCache(requestsIds);
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    List<UserFull> getFriendshipSuggestions() {
        try {
            GetSuggestionsResponse resp = (GetSuggestionsResponse)this.vk.friends().getSuggestions(this.actor).fields(new Fields[]{Fields.STATUS, Fields.LAST_SEEN, Fields.CITY, Fields.BDATE, Fields.RELATION, Fields.SEX}).execute();
            List l = resp.getItems();
            for (UserFull u : l) {
                if (this.app.userCache.containsKey(u.getId())) continue;
                this.app.userCache.put(u.getId(), u);
            }
            return l;
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    void savePersonalInfo(SaveProfileInfoRelation rel) {
        try {
            SaveProfileInfoResponse saveProfileInfoResponse = (SaveProfileInfoResponse)this.vk.account().saveProfileInfo(this.actor).relation(rel).execute();
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    UserSettingsXtr getPersonalInfo() {
        try {
            return (UserSettingsXtr)this.vk.account().getProfileInfo(this.actor).execute();
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    void test() {
        try {
            AudioGetUploadServerQuery q = new AudioGetUploadServerQuery(this.vk, this.actor);
            AudioGetUploadServerResponse audioGetUploadServerResponse = (AudioGetUploadServerResponse)q.execute();
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    List<UserFull> getLikesWallPost(int ownerId, int postId) {
        try {
            GetListResponse resp = (GetListResponse)this.vk.likes().getList(this.actor, Type.POST).ownerId(Integer.valueOf(ownerId)).itemId(Integer.valueOf(postId)).execute();
            return this.getUsersForCacheIntList(resp.getItems());
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    void addLikeWallPost(WallpostFull wallPost) {
        try {
            this.vk.likes().add(this.actor, Type.POST, wallPost.getId().intValue()).ownerId(wallPost.getOwnerId()).execute();
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    String getStatus() {
        try {
            com.vk.api.sdk.objects.status.responses.GetResponse resp = (com.vk.api.sdk.objects.status.responses.GetResponse)this.vk.status().get(this.actor).execute();
            return resp.getText();
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    void setStatus(String text) {
        try {
            this.vk.status().set(this.actor).text(text).execute();
        }
        catch (ApiException | ClientException e) {
            throw new RuntimeException(e);
        }
    }

    List<UserFull> getUsersForCache(Integer[] ids) throws ApiException, ClientException {
        ArrayList<String> list = new ArrayList<String>();
        for (Integer i : ids) {
            list.add(i.toString());
        }
        return this.getUsersForCache(list);
    }

    List<UserFull> getUsersForCacheIntList(List<Integer> ids) throws ApiException, ClientException {
        ArrayList<String> list = new ArrayList<String>();
        for (Integer i : ids) {
            list.add(i.toString());
        }
        return this.getUsersForCache(list);
    }

    List<UserFull> getUsersForCache(List<String> ids) throws ApiException, ClientException {
        List resp = (List)this.vk.users().get(this.actor).userIds(ids).fields(new Fields[]{Fields.STATUS, Fields.LAST_SEEN, Fields.CITY, Fields.BDATE, Fields.RELATION, Fields.SEX}).execute();
        ArrayList<UserFull> res = new ArrayList<UserFull>();
        res.addAll(resp);
        for (UserFull u : res) {
            this.app.userCache.put(u.getId(), u);
        }
        return res;
    }
}

