/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk2;

import com.vk.api.sdk.objects.base.BoolInt;
import com.vk.api.sdk.objects.messages.Conversation;
import com.vk.api.sdk.objects.messages.ConversationWithMessage;
import com.vk.api.sdk.objects.messages.Message;
import java.util.Set;
import org.luwrain.app.vk2.App;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Sounds;

public final class ChatsAppearance
extends ListUtils.AbstractAppearance<ConversationWithMessage> {
    final App app;

    public ChatsAppearance(App app) {
        this.app = app;
    }

    public void announceItem(ConversationWithMessage chat, Set<ListArea.Appearance.Flags> flags) {
        Conversation conv = chat.getConversation();
        Message message = chat.getLastMessage();
        boolean noUnread = message.getOut() == BoolInt.YES ? conv.getOutRead().equals(message.getId()) : conv.getInRead().equals(message.getId());
        String title = message.getOut() == BoolInt.YES ? this.app.getUserCommonName(message.getPeerId()) : this.app.getUserCommonName(message.getFromId());
        Sounds sound = message.getOut() == BoolInt.YES ? (noUnread ? Sounds.SELECTED : Sounds.LIST_ITEM) : (noUnread ? Sounds.SELECTED : Sounds.ATTENTION);
        this.app.setEventResponse(DefaultEventResponse.listItem((Sounds)sound, (String)(title + ": " + message.getText()), null));
    }

    public String getScreenAppearance(ConversationWithMessage chat, Set<ListArea.Appearance.Flags> flags) {
        Conversation conv = chat.getConversation();
        Message message = chat.getLastMessage();
        if (conv.getUnreadCount() != null) {
            return this.app.getUserCommonName(message.getFromId()) + " (" + conv.getUnreadCount() + "): " + message.getText();
        }
        return this.app.getUserCommonName(message.getFromId()) + ": " + message.getText();
    }
}

