/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.lsocial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.lsocial.App;
import org.luwrain.app.lsocial.LayoutExt;
import org.luwrain.app.lsocial.PublLayoutExt;
import org.luwrain.app.lsocial.Strings;
import org.luwrain.app.lsocial.layouts.NewEntryLayout;
import org.luwrain.app.lsocial.layouts.OptionsLayout;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.list.DoubleLevelAppearance;
import org.luwrain.controls.list.ListModel;
import org.luwrain.core.Area;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.events.InputEvent;
import org.luwrain.io.api.lsocial.presentation.DeleteQuery;
import org.luwrain.io.api.lsocial.presentation.DeleteResponse;
import org.luwrain.io.api.lsocial.presentation.ListResponse;
import org.luwrain.io.api.lsocial.presentation.Presentation;
import org.luwrain.io.api.lsocial.publication.GetQuery;
import org.luwrain.io.api.lsocial.publication.GetResponse;
import org.luwrain.io.api.lsocial.publication.ListQuery;
import org.luwrain.io.api.lsocial.publication.Publication;

public class MainLayout
extends LayoutBase
implements ListArea.ClickHandler<Object> {
    private static final Logger log = LogManager.getLogger();
    public final List<Object> entries = new ArrayList<Object>();
    public final ListArea<Object> mainList;
    final LayoutBase.Actions mainListActions;
    final App app;
    private LayoutExt ext = null;

    MainLayout(App app) {
        super((AppBase)app);
        this.app = app;
        Strings s = (Strings)app.getStrings();
        this.mainList = new ListArea(this.listParams(p -> {
            p.name = s.appName();
            p.model = new ListModel(this.entries);
            p.appearance = new MainListAppearance(this.getControlContext());
            p.clickHandler = this;
        }));
        this.setPropertiesHandler((Area)this.mainList, a -> new OptionsLayout(app, this.getReturnAction()));
        this.mainListActions = this.actions(new LayoutBase.ActionInfo[]{this.action("insert", s.create(), new InputEvent(InputEvent.Special.INSERT), () -> {
            app.setAreaLayout(new NewEntryLayout(app, this, this.getReturnAction()));
            return true;
        }), this.action("delete", s.delete(), new InputEvent(InputEvent.Special.DELETE), this::onMainListDelete)});
        this.setAreaLayout((Area)this.mainList, this.mainListActions);
    }

    public boolean onListClick(ListArea<Object> area, int index, Object obj) {
        if (obj instanceof Publication) {
            Publication publ = (Publication)obj;
            return this.onPublClick(publ);
        }
        return false;
    }

    boolean onPublClick(Publication publ) {
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            GetResponse res = (GetResponse)((GetQuery)new GetQuery("https://luwrain.social").accessToken(this.app.conf.getAccessToken())).mode(500).publ(publ.getId()).exec();
            this.app.finishedTask(taskId, () -> this.openExt(new PublLayoutExt(this, res.getPubl())));
        });
    }

    boolean onMainListDelete() {
        Object selected = this.mainList.selected();
        if (selected == null) {
            return false;
        }
        if (selected instanceof Publication) {
            Publication publ = (Publication)selected;
            return this.onDelete(publ);
        }
        if (selected instanceof Presentation) {
            Presentation pr = (Presentation)selected;
            return this.onDelete(pr);
        }
        return false;
    }

    boolean onDelete(Publication publ) {
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            org.luwrain.io.api.lsocial.publication.DeleteResponse res = (org.luwrain.io.api.lsocial.publication.DeleteResponse)((org.luwrain.io.api.lsocial.publication.DeleteQuery)new org.luwrain.io.api.lsocial.publication.DeleteQuery("https://luwrain.social").accessToken(this.app.conf.getAccessToken())).publ(publ).exec();
            this.app.finishedTask(taskId, () -> {});
        });
    }

    boolean onDelete(Presentation pr) {
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            DeleteResponse res = (DeleteResponse)((DeleteQuery)new DeleteQuery("https://luwrain.social").accessToken(this.app.conf.getAccessToken())).pr(pr).exec();
            this.app.finishedTask(taskId, () -> {});
        });
    }

    void openExt(LayoutExt ext) {
        this.ext = ext;
        ext.setLayout();
        this.app.setAreaLayout(this);
        ext.activateDefaultArea();
    }

    public List<Object> fetchMainListItems() throws IOException {
        log.trace("Starting updating the main list");
        ArrayList<Object> res = new ArrayList<Object>();
        log.trace("Querying presentations");
        ListResponse prRes = (ListResponse)((org.luwrain.io.api.lsocial.presentation.ListQuery)new org.luwrain.io.api.lsocial.presentation.ListQuery("https://luwrain.social").accessToken(this.app.conf.getAccessToken())).exec();
        res.addAll(prRes.getEn());
        log.trace("Querying publications");
        org.luwrain.io.api.lsocial.publication.ListResponse publRes = (org.luwrain.io.api.lsocial.publication.ListResponse)((ListQuery)new ListQuery("https://luwrain.social").accessToken(this.app.conf.getAccessToken())).exec();
        res.addAll(publRes.getEn());
        return res;
    }

    void updateMainList() {
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        this.app.runTask(taskId, () -> {
            List<Object> res = this.fetchMainListItems();
            this.app.finishedTask(taskId, () -> {
                this.entries.clear();
                this.entries.addAll(res);
                this.mainList.refresh();
            });
        });
    }

    final class MainListAppearance
    extends DoubleLevelAppearance<Object> {
        MainListAppearance(ControlContext context) {
            super(context);
        }

        public boolean isSectionItem(Object obj) {
            return false;
        }

        public void announceNonSection(Object item) {
            Strings s = (Strings)MainLayout.this.app.getStrings();
            if (item instanceof Publication) {
                Publication publ = (Publication)item;
                MainLayout.this.app.setEventResponse(DefaultEventResponse.listItem((String)(publ.getName() + " " + s.publicationListSuffix())));
            } else if (item instanceof Presentation) {
                Presentation pr = (Presentation)item;
                MainLayout.this.app.setEventResponse(DefaultEventResponse.listItem((String)(pr.getName() + " " + s.presentationListSuffix())));
            } else {
                MainLayout.this.app.setEventResponse(DefaultEventResponse.listItem((String)item.toString()));
            }
        }

        public String getNonSectionScreenAppearance(Object item) {
            if (item instanceof Publication) {
                Publication publ = (Publication)item;
                return publ.getName();
            }
            if (item instanceof Presentation) {
                Presentation pr = (Presentation)item;
                return pr.getName();
            }
            return item.toString();
        }
    }
}

