/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player;

public final class Album
implements Comparable {
    private String title = null;
    private String url = null;
    private String path = null;
    private Integer volume = null;
    private Integer trackNum = null;
    private Type type = null;
    private Boolean savePos = null;
    private Long posMsec = null;

    public Type getType() {
        return this.type != null ? this.type : Type.UNKNOWN;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title != null ? this.title.trim() : "";
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url != null ? this.url.trim() : "";
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPath() {
        return this.path != null ? this.path : "";
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getVolume() {
        if (this.volume == null) {
            return 100;
        }
        return Math.min(Math.max(this.volume, 0), 100);
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public boolean isSavePosition() {
        return this.savePos != null ? this.savePos : false;
    }

    public void setSavePosition(boolean value) {
        this.savePos = value;
    }

    public int getTrackNum() {
        return this.trackNum != null ? this.trackNum : 0;
    }

    public void setTrackNum(int value) {
        this.trackNum = value;
    }

    public long getPosMsec() {
        return this.posMsec != null ? this.posMsec : 0L;
    }

    public void setPosMsec(long value) {
        this.posMsec = value;
    }

    public boolean isSection() {
        return this.type == Type.SECTION;
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Album)) {
            return 0;
        }
        return this.getTitle().compareTo(((Album)o).getTitle());
    }

    public String toString() {
        return this.getTitle();
    }

    public static enum Type {
        SECTION,
        STREAMING,
        DIR,
        M3U,
        UNKNOWN;

    }
}

