/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.linux.BashProcess;
import org.luwrain.linux.WifiNetwork;

public final class NmCli {
    private static final String LOG_COMPONENT = "nmcli";
    private static final String IN_USE = "IN-USE:";
    private static final String SECURITY = "SECURITY:";
    private static final String SSID = "SSID:";
    private static final String SIGNAL = "SIGNAL:";
    private final Caller caller;

    public NmCli(Caller caller) {
        NullCheck.notNull((Object)caller, (String)"caller");
        this.caller = caller;
    }

    public NmCli() {
        this(NmCli.createDefaultCaller());
    }

    public WifiNetwork[] scan() throws IOException {
        ArrayList<Network> res = new ArrayList<Network>();
        String[] lines = this.caller.call(new String[]{"device", "wifi", "list"});
        String ssid = null;
        String security = null;
        String inUse = null;
        String signal = null;
        for (String l : lines) {
            String line = l.trim();
            if (line.startsWith(IN_USE)) {
                inUse = line.substring(IN_USE.length()).trim();
            }
            if (line.startsWith(SSID)) {
                ssid = line.substring(SSID.length()).trim();
            }
            if (line.startsWith(SIGNAL)) {
                signal = line.substring(SIGNAL.length()).trim();
            }
            if (line.startsWith(SECURITY)) {
                security = line.substring(SECURITY.length()).trim();
            }
            if (ssid == null || inUse == null || signal == null || security == null) continue;
            int level = 0;
            try {
                level = Integer.parseInt(signal);
            }
            catch (NumberFormatException e) {
                Log.warning((String)LOG_COMPONENT, (String)("unparsable signal level value: " + signal));
            }
            res.add(new Network(ssid, security.trim(), !inUse.trim().isEmpty(), level));
            inUse = null;
            ssid = null;
            security = null;
            signal = null;
        }
        return res.toArray(new WifiNetwork[res.size()]);
    }

    public boolean connect(WifiNetwork network, String password) throws IOException {
        try {
            if (password != null && !password.isEmpty()) {
                this.caller.call(new String[]{"device", "wifi", "connect", network.getName(), "password", password});
            } else {
                this.caller.call(new String[]{"device", "wifi", "connect", network.getName()});
            }
            return true;
        }
        catch (Throwable e) {
            Log.error((String)LOG_COMPONENT, (String)("unable to connect to the network '" + network.getName() + "': " + e.getClass().getName() + ": " + e.getMessage()));
            return false;
        }
    }

    public boolean disconnect() throws IOException {
        return false;
    }

    public static Caller createDefaultCaller() {
        return args -> {
            StringBuilder cmd = new StringBuilder();
            cmd.append("nmcli -m multiline");
            if (args != null) {
                for (String a : args) {
                    cmd.append(" ").append(BashProcess.escape(a));
                }
            }
            BashProcess p = new BashProcess(new String(cmd), EnumSet.of(BashProcess.Flags.ROOT, BashProcess.Flags.LOG_OUTPUT));
            p.run();
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                throw new IOException("nmcli returned " + String.valueOf(exitCode));
            }
            return p.getOutput();
        };
    }

    public static interface Caller {
        public String[] call(String[] var1) throws IOException;
    }

    private static final class Network
    implements WifiNetwork {
        private final String name;
        private final String protectionType;
        private boolean connected = false;
        private final int signalLevel;

        Network(String name, String protectionType, boolean connected, int signalLevel) {
            NullCheck.notNull((Object)name, (String)"name");
            NullCheck.notNull((Object)protectionType, (String)"protectionType");
            this.name = name;
            this.protectionType = protectionType;
            this.signalLevel = signalLevel;
            this.connected = connected;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getProtectionType() {
            return this.protectionType;
        }

        @Override
        public boolean isConnected() {
            return this.connected;
        }

        @Override
        public int getSignalLevel() {
            return this.signalLevel;
        }

        public String toString() {
            return this.name;
        }
    }
}

