/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class TermInfo {
    final String text;
    private String termName = null;
    private Set<String> values = new HashSet<String>();
    private Map<Character, Map<String, String>> seqs = new HashMap<Character, Map<String, String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TermInfo() throws IOException {
        Process p = new ProcessBuilder("infocmp", "linux").start();
        p.getOutputStream().close();
        StringBuilder b = new StringBuilder();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line = r.readLine();
            while (line != null) {
                if (!line.isEmpty() && !line.startsWith("#")) {
                    b.append(line);
                }
                line = r.readLine();
            }
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (p.exitValue() != 0) {
            throw new IOException("Unable to read the terminfo database, exit value is " + String.valueOf(p.exitValue()));
        }
        this.text = new String(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void read() {
        b = new StringBuilder();
        try {
            r = new StringReader(this.text);
            try {
                codeBuilder = null;
                n = r.read();
                while (n >= 0) {
                    c = (char)n;
                    if (codeBuilder == null) ** GOTO lbl17
                    if (c >= '0' && c <= '9') {
                        codeBuilder.append(c);
                    } else {
                        b.append(this.buildChar(new String(codeBuilder)));
                        codeBuilder = null;
lbl17:
                        // 2 sources

                        block3 : switch (c) {
                            case ' ': {
                                if (b.length() <= 0) break;
                                b.append(' ');
                                break;
                            }
                            case '\t': {
                                break;
                            }
                            case ',': {
                                this.processItem(new String(b));
                                b = new StringBuilder();
                                break;
                            }
                            case '\\': {
                                nn = r.read();
                                if (nn < 0) {
                                    b.append('\\');
                                    return;
                                }
                                cc = (char)nn;
                                switch (cc) {
                                    case 'E': 
                                    case 'e': {
                                        b.append('\u001b');
                                        break block3;
                                    }
                                    case 'N': 
                                    case 'n': {
                                        b.append('\n');
                                        break block3;
                                    }
                                    case 'R': 
                                    case 'r': {
                                        b.append('\r');
                                        break block3;
                                    }
                                    case 'T': 
                                    case 't': {
                                        b.append('\r');
                                        break block3;
                                    }
                                }
                                if (cc < '0' || cc > '9') {
                                    b.append(cc);
                                    break;
                                }
                                codeBuilder = new StringBuilder();
                                codeBuilder.append(cc);
                                break;
                            }
                            default: {
                                b.append(c);
                            }
                        }
                    }
                    n = r.read();
                }
            }
            finally {
                r.close();
                if (b.length() > 0) {
                    this.processItem(new String(b));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String buildChar(String code) {
        try {
            return Character.toString((char)Integer.parseInt(code));
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    private void processItem(String text) {
        int pos = text.indexOf("=");
        if (pos > 0 && pos < text.length() - 1) {
            String name = text.substring(0, pos);
            String value = text.substring(pos + 1);
            Character c = new Character(value.charAt(0));
            Map<String, String> m = this.seqs.get(c);
            if (m == null) {
                m = new HashMap<String, String>();
                this.seqs.put(c, m);
            }
            m.put(value, name);
            return;
        }
        if (this.termName == null) {
            this.termName = text;
            return;
        }
        this.values.add(text);
    }

    public String find(String seq) {
        Map<String, String> m;
        if (seq.length() == 1 && seq.charAt(0) == '\u001b') {
            return "";
        }
        if (seq.length() >= 2 && seq.charAt(0) == '\u001b' && seq.charAt(1) == '[') {
            if (seq.length() == 2) {
                return "";
            }
            if (seq.substring(2).matches("^[0-9;]+$")) {
                return "";
            }
            if (seq.endsWith("m")) {
                return "color";
            }
        }
        if ((m = this.seqs.get(new Character(seq.charAt(0)))) == null) {
            return null;
        }
        String s = m.get(seq);
        if (s != null) {
            return s;
        }
        for (Map.Entry<String, String> e : m.entrySet()) {
            if (!e.getKey().startsWith(seq)) continue;
            return "";
        }
        return null;
    }

    String getTermName() {
        return this.termName != null ? this.termName : "";
    }
}

