/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.Luwrain;
import org.luwrain.linux.services.UdisksCli;
import org.luwrain.linux.services.UdisksCliMonitor;
import org.luwrain.popups.DisksPopup;

public final class DefaultDisksPopupFactory
implements DisksPopup.Factory {
    private static final Logger log = LogManager.getLogger();
    private final UdisksCliMonitor monitor;

    DefaultDisksPopupFactory(UdisksCliMonitor monitor) {
        this.monitor = monitor;
    }

    public DisksPopup.Disks newDisks(Luwrain luwrain) {
        return new DisksImpl(this.monitor);
    }

    static final class DisksImpl
    implements DisksPopup.Disks {
        final UdisksCliMonitor monitor;

        DisksImpl(UdisksCliMonitor monitor) {
            this.monitor = Objects.requireNonNull(monitor, "monitor can't be null");
        }

        public DisksPopup.Disk[] getDisks(Set<DisksPopup.Flags> flags) {
            ArrayList res = new ArrayList();
            this.monitor.enumRemovableBlockDevices(m -> {
                boolean removable;
                String obj = m.containsKey("obj") ? m.get("obj").toString() : "";
                String device = m.containsKey("device") ? m.get("device").toString() : "";
                String fsType = m.containsKey("fsType") ? m.get("fsType").toString() : "";
                String mountPoints = m.containsKey("mountPoints") ? m.get("mountPoints").toString() : "";
                boolean ejectable = m.containsKey("ejectable") ? (Boolean)m.get("ejectable") : false;
                boolean bl = removable = m.containsKey("removable") ? (Boolean)m.get("removable") : false;
                if (removable && !fsType.trim().isEmpty()) {
                    res.add(new DiskImpl(device, mountPoints));
                }
            });
            return res.toArray(new DisksPopup.Disk[res.size()]);
        }
    }

    static final class DiskImpl
    implements DisksPopup.Disk {
        final String title;
        final String device;
        private String mountPoint = null;

        DiskImpl(String device, String mountPoint) {
            this.title = device.startsWith("/dev/") ? device.substring(5) : device;
            this.device = device;
            this.mountPoint = mountPoint;
        }

        public boolean isActivated() {
            return this.mountPoint != null && !this.mountPoint.trim().isEmpty();
        }

        public File activate(Set<DisksPopup.Flags> flags) {
            if (this.mountPoint != null && !this.mountPoint.trim().isEmpty()) {
                return new File(this.mountPoint);
            }
            UdisksCli u = new UdisksCli();
            try {
                return u.mount(this.device);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        public boolean deactivate(Set<DisksPopup.Flags> flags) {
            UdisksCli u = new UdisksCli();
            try {
                u.unmount(this.device);
                this.mountPoint = null;
                return true;
            }
            catch (Throwable e) {
                log.error((Object)e);
                throw new RuntimeException(e);
            }
        }

        public boolean poweroff(Set<DisksPopup.Flags> flags) {
            UdisksCli u = new UdisksCli();
            try {
                u.poweroff(this.device);
                return true;
            }
            catch (Throwable e) {
                log.error((Object)e);
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.title;
        }
    }
}

