/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.install;

import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.install.App;
import org.luwrain.app.install.Strings;
import org.luwrain.controls.WizardArea;
import org.luwrain.core.Area;
import org.luwrain.core.NullCheck;

final class MainLayout
extends LayoutBase {
    private final App app;
    final WizardArea wizardArea;

    MainLayout(App app) {
        super((AppBase)app);
        this.app = app;
        this.wizardArea = new WizardArea(this.getControlContext());
        this.setAreaLayout((Area)this.wizardArea, this.actions(new LayoutBase.ActionInfo[0]));
        WizardArea.Frame devFrame = this.wizardArea.newFrame().addText(((Strings)app.getStrings()).greeting());
        for (String f : app.blockDevices.getHardDrives()) {
            devFrame.addClickable(this.getDeviceStr(f), values -> false);
        }
        this.wizardArea.show(devFrame);
    }

    private String getDeviceStr(String f) {
        NullCheck.notNull((Object)f, (String)"f");
        StringBuilder b = new StringBuilder();
        b.append(f).append(", ").append(this.app.blockDevices.getDeviceSize(f) / 0x100000L / 1024L).append("G, ").append(this.app.blockDevices.getDeviceName(f));
        return new String(b);
    }
}

