/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

public final class NullCheck {
    public static void notNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException(name + " can't be null");
        }
    }

    public static void notEmpty(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException(name + " can't be null");
        }
        if (obj.toString().isEmpty()) {
            throw new IllegalArgumentException(name + " can't be empty");
        }
    }

    public static void notNullItems(Object[] items, String name) {
        NullCheck.notNull(items, name);
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != null) continue;
            throw new NullPointerException(name + "[" + i + "] can't be null");
        }
    }

    public static void notEmptyItems(Object[] items, String name) {
        if (items == null) {
            throw new NullPointerException(name + " can't be null");
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) {
                throw new NullPointerException(name + "[" + i + "] can't be null");
            }
            if (!items[i].toString().isEmpty()) continue;
            throw new IllegalArgumentException(name + "[" + i + "] can't be empty");
        }
    }

    public static void notEmptyArray(Object[] items, String name) {
        if (items == null) {
            throw new NullPointerException(name + " can't be null");
        }
        if (items.length < 1) {
            throw new IllegalArgumentException(name + " can't be empty");
        }
    }
}

